/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.AbstractCompleter;
import org.jboss.as.cli.impl.aesh.cmd.LegacyBridge;
import org.jboss.as.cli.impl.aesh.cmd.deployment.AbstractDeployCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeploymentCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="enable", description="", activator=ControlledCommandActivator.class)
public class EnableCommand
extends AbstractDeployCommand
implements LegacyBridge {
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    private boolean help;
    @Argument(required=true, activator=OptionActivators.NameActivator.class, completer=NameCompleter.class)
    public String name;

    public EnableCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.enableAccess(permissions), permissions);
    }

    @Deprecated
    public EnableCommand(CommandContext ctx) {
        this(ctx, (Permissions)null);
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deployment enable"));
            return CommandResult.SUCCESS;
        }
        return this.execute(commandInvocation.getCommandContext());
    }

    @Override
    public CommandResult execute(CommandContext ctx) throws CommandException {
        if (this.name == null || this.name.isEmpty()) {
            throw new CommandException("No deployment name");
        }
        EnableCommand.deployName(ctx, this.name, this.allServerGroups, this.serverGroups, this.headers);
        return CommandResult.SUCCESS;
    }

    static void deployName(CommandContext ctx, String name, boolean allServerGroups, String serverGroups, ModelNode headers) throws CommandException {
        try {
            ModelNode request = EnableCommand.buildRequest(ctx, name, allServerGroups, serverGroups, headers);
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (!Util.isSuccess(result)) {
                throw new CommandException(Util.getFailureDescription(result));
            }
        }
        catch (IOException e) {
            throw new CommandException("Failed to deploy", (Throwable)e);
        }
        catch (CommandFormatException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        return EnableCommand.buildRequest(context, this.name, this.allServerGroups, this.serverGroups, this.headers);
    }

    private static ModelNode buildRequest(CommandContext ctx, String name, boolean allServerGroups, String serverGroups, ModelNode headers) throws CommandFormatException {
        ModelNode deployRequest = new ModelNode();
        if (ctx.isDomainMode()) {
            List<String> sgList = DeploymentCommand.getServerGroups(ctx, ctx.getModelControllerClient(), allServerGroups, serverGroups, null);
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            ModelNode steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (serverGroups != null || allServerGroups) {
                throw new CommandFormatException("--all-server-groups and --server-groups can't appear in standalone mode.");
            }
            deployRequest.get("operation").set("deploy");
            deployRequest.get(new String[]{"address", "deployment"}).set(name);
        }
        if (!ctx.isBatchMode() && !Util.isDeploymentInRepository(name, ctx.getModelControllerClient())) {
            throw new CommandFormatException("'" + name + "' is not found among the registered deployments.");
        }
        if (headers != null) {
            ModelNode opHeaders = deployRequest.get("operation-headers");
            opHeaders.set(headers);
        }
        return deployRequest;
    }

    public static class NameCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(CLICompleterInvocation completerInvocation) {
            List<String> deployments = Collections.emptyList();
            if (completerInvocation.getCommandContext().getModelControllerClient() != null) {
                deployments = Util.getDeployments(completerInvocation.getCommandContext().getModelControllerClient());
            }
            return deployments;
        }
    }
}

