/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ClusteredCacheBuilder
extends CacheConfigurationBuilder {
    private final CacheMode mode;
    private volatile ClusteringConfiguration clustering;

    ClusteredCacheBuilder(PathAddress address, CacheMode mode) {
        super(address);
        this.mode = mode.toSync();
    }

    @Override
    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering().cacheMode(this.mode);
        builder.remoteTimeout(ClusteredCacheResourceDefinition.Attribute.REMOTE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong());
        this.clustering = builder.create();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        builder.clustering().read(this.clustering);
        super.accept(builder);
    }
}

