/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class JDBCStoreBuilder
extends StoreBuilder<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    private final ValueDependency<TableManipulationConfiguration> table;
    private volatile ValueDependency<Module> module;
    private volatile ValueDependency<DataSource> dataSource;
    private volatile DatabaseType dialect;

    JDBCStoreBuilder(PathAddress address) {
        super(address, JdbcStringBasedStoreConfigurationBuilder.class);
        PathAddress cacheAddress = address.getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        this.table = new InjectedValueDependency(CacheComponent.STRING_TABLE.getServiceName(cacheAddress), TableManipulationConfiguration.class);
        this.module = new InjectedValueDependency(CacheContainerComponent.MODULE.getServiceName(containerAddress), Module.class);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        ServiceBuilder<PersistenceConfiguration> builder = super.build(target);
        Stream.of(this.table, this.module, this.dataSource).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.dataSource = new InjectedValueDependency(CommonUnaryRequirement.DATA_SOURCE.getServiceName(context, dataSource), DataSource.class);
        this.dialect = ModelNodes.optionalEnum((ModelNode)JDBCStoreResourceDefinition.Attribute.DIALECT.resolveModelAttribute((ExpressionResolver)context, model), DatabaseType.class).orElse(null);
        return super.configure(context, model);
    }

    @Override
    public void accept(JdbcStringBasedStoreConfigurationBuilder builder) {
        builder.table().read((TableManipulationConfiguration)this.table.getValue());
        StreamSupport.stream(ServiceLoader.load(TwoWayKey2StringMapper.class, (ClassLoader)((Module)this.module.getValue()).getClassLoader()).spliterator(), false).findFirst().ifPresent(impl -> builder.key2StringMapper(impl.getClass()));
        ((DataSourceConnectionFactoryConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.dialect(this.dialect)).connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Value<DataSource>)this.dataSource);
    }
}

