/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.clustering.service.UnaryRequirement;

public abstract class JDBCStoreResourceDefinition
extends StoreResourceDefinition {
    static final PathElement PATH = JDBCStoreResourceDefinition.pathElement("jdbc");
    static final AttributeValueTranslator POOL_NAME_TO_JNDI_NAME_TRANSLATOR = new AttributeValueTranslator(){

        public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
            String poolName = value.asString();
            PathAddress address = context.getCurrentAddress();
            PathAddress rootAddress = address.subAddress(0, address.size() - 4);
            PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
            Resource subsystem = context.readResourceFromRoot(subsystemAddress);
            for (String type : Arrays.asList("data-source", "xa-data-source")) {
                Resource resource = subsystem.getChild(PathElement.pathElement((String)type, (String)poolName));
                if (resource == null) continue;
                return resource.getModel().get("jndi-name");
            }
            throw InfinispanLogger.ROOT_LOGGER.dataSourceNotFound(poolName);
        }
    };
    static final AttributeValueTranslator JNDI_NAME_TO_POOL_NAME_TRANSLATOR = new AttributeValueTranslator(){

        public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
            String jndiName = value.asString();
            PathAddress address = context.getCurrentAddress();
            PathAddress rootAddress = address.subAddress(0, address.size() - 4);
            PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
            Resource subsystem = context.readResourceFromRoot(subsystemAddress);
            for (String type : Arrays.asList("data-source", "xa-data-source")) {
                if (!subsystem.hasChildren(type)) continue;
                for (Resource.ResourceEntry entry : subsystem.getChildren(type)) {
                    ModelNode model = entry.getModel();
                    if (!model.get("jndi-name").asString().equals(jndiName)) continue;
                    return new ModelNode(entry.getName());
                }
            }
            throw InfinispanLogger.ROOT_LOGGER.dataSourceJndiNameNotFound(jndiName);
        }
    };

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder builder, PathElement path) {
        if (InfinispanModel.VERSION_5_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attribute.DIALECT.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(DatabaseType.MARIA_DB.name())), new AttributeDefinition[]{Attribute.DIALECT.getDefinition()});
            if (!InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
                builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{DeprecatedAttribute.DATASOURCE.getDefinition()});
            }
        }
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            SimpleAttributeConverter.Converter converter = new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    if (value.isDefined()) {
                        PathAddress rootAddress = address.subAddress(0, address.size() - 4);
                        PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
                        Resource subsystem = context.readResourceFromRoot(subsystemAddress);
                        String poolName = value.asString();
                        for (String type : Arrays.asList("data-source", "xa-data-source")) {
                            if (!subsystem.hasChildren(type)) continue;
                            for (Resource.ResourceEntry entry : subsystem.getChildren(type)) {
                                if (!entry.getName().equals(poolName)) continue;
                                value.set(entry.getModel().get("jndi-name"));
                                return;
                            }
                        }
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRename(Attribute.DATA_SOURCE.getName(), DeprecatedAttribute.DATASOURCE.getName())).setValueConverter((AttributeConverter)new SimpleAttributeConverter(converter), new AttributeDefinition[]{Attribute.DATA_SOURCE.getDefinition()});
        }
        StoreResourceDefinition.buildTransformation(version, builder, path);
        if (InfinispanModel.VERSION_2_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.DIALECT.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.DIALECT.getDefinition()})).end();
        }
    }

    JDBCStoreResourceDefinition(PathElement path, PathElement legacyPath, ResourceDescriptionResolver resolver, Consumer<ResourceDescriptor> configurator, Consumer<ManagementResourceRegistration> registrationConfigurator) {
        super(path, legacyPath, resolver, configurator.andThen(descriptor -> descriptor.addAttributes(Attribute.class).addAttributeTranslation((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.DATASOURCE, (org.jboss.as.clustering.controller.Attribute)Attribute.DATA_SOURCE, POOL_NAME_TO_JNDI_NAME_TRANSLATOR, JNDI_NAME_TO_POOL_NAME_TRANSLATOR)), (ResourceServiceBuilderFactory<PersistenceConfiguration>)((ResourceServiceBuilderFactory)JDBCStoreBuilder::new), registrationConfigurator);
    }

    static class TableAttributeTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final org.jboss.as.clustering.controller.Attribute attribute;
        private final PathElement path;

        TableAttributeTransformation(org.jboss.as.clustering.controller.Attribute attribute, PathElement path) {
            this.attribute = attribute;
            this.path = path;
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (operation.hasDefined(this.attribute.getName())) {
                    ModelNode addTableOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{this.path}));
                    ModelNode parameters = operation.get(this.attribute.getName());
                    for (Property parameter : parameters.asPropertyList()) {
                        addTableOperation.get(parameter.getName()).set(parameter.getValue());
                    }
                    context.addStep(addTableOperation, context.getResourceRegistration().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{this.path}), "add"), context.getCurrentStage());
                }
                handler.execute(context, operation);
            };
        }

        public UnaryOperator<OperationStepHandler> andThen(UnaryOperator<OperationStepHandler> after) {
            return handler -> (OperationStepHandler)after.apply(this.apply((OperationStepHandler)handler));
        }
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        DATASOURCE("datasource", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false), InfinispanModel.VERSION_4_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DATA_SOURCE("data-source", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((Capability)StoreResourceDefinition.Capability.PERSISTENCE, (UnaryRequirement)CommonUnaryRequirement.DATA_SOURCE))).setAlternatives(new String[]{DeprecatedAttribute.DATASOURCE.getName()})),
        DIALECT("dialect", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false)).setValidator((ParameterValidator)new EnumValidator(DatabaseType.class)));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

