/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.destination;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.destination.DestinationAction;

@Command(name="delete", description="delete a queue or topic")
public class DeleteDestination
extends DestinationAction {
    @Option(name={"--removeConsumers"}, description="whether deleting destination with consumers or not (default false)")
    boolean removeConsumers = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        if ("jms-queue".equals(this.destType)) {
            this.deleteJmsQueue(context);
        } else if ("core-queue".equals(this.destType)) {
            this.deleteCoreQueue(context);
        } else if ("topic".equals(this.destType)) {
            this.deleteJmsTopic(context);
        } else {
            throw new IllegalArgumentException("--type can only be one of jms-queue, topic and core-queue");
        }
        return null;
    }

    private void deleteJmsTopic(final ActionContext context) throws Exception {
        this.performJmsManagement(new DestinationAction.ManagementCallback<Message>(){

            @Override
            public void setUpInvocation(Message message) throws Exception {
                JMSManagementHelper.putOperationInvocation((Message)message, (String)"jms.server", (String)"destroyTopic", (Object[])new Object[]{DeleteDestination.this.getName(), DeleteDestination.this.removeConsumers});
            }

            @Override
            public void requestSuccessful(Message reply) throws Exception {
                boolean result = (Boolean)JMSManagementHelper.getResult((Message)reply, Boolean.class);
                if (result) {
                    context.out.println("Topic " + DeleteDestination.this.getName() + " deleted successfully.");
                } else {
                    context.err.println("Failed to delete topic " + DeleteDestination.this.getName());
                }
            }

            @Override
            public void requestFailed(Message reply) throws Exception {
                String errorMsg = (String)JMSManagementHelper.getResult((Message)reply, String.class);
                context.err.println("Failed to delete topic " + DeleteDestination.this.getName() + ". Reason: " + errorMsg);
            }
        });
    }

    private void deleteJmsQueue(final ActionContext context) throws Exception {
        this.performJmsManagement(new DestinationAction.ManagementCallback<Message>(){

            @Override
            public void setUpInvocation(Message message) throws Exception {
                JMSManagementHelper.putOperationInvocation((Message)message, (String)"jms.server", (String)"destroyQueue", (Object[])new Object[]{DeleteDestination.this.getName(), DeleteDestination.this.removeConsumers});
            }

            @Override
            public void requestSuccessful(Message reply) throws Exception {
                boolean result = (Boolean)JMSManagementHelper.getResult((Message)reply, Boolean.class);
                if (result) {
                    context.out.println("Jms queue " + DeleteDestination.this.getName() + " deleted successfully.");
                } else {
                    context.err.println("Failed to delete queue " + DeleteDestination.this.getName());
                }
            }

            @Override
            public void requestFailed(Message reply) throws Exception {
                String errorMsg = (String)JMSManagementHelper.getResult((Message)reply, String.class);
                context.err.println("Failed to create " + DeleteDestination.this.getName() + " with reason: " + errorMsg);
            }
        });
    }

    private void deleteCoreQueue(final ActionContext context) throws Exception {
        this.performCoreManagement(new DestinationAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((org.apache.activemq.artemis.api.core.Message)message, (String)"core.server", (String)"destroyQueue", (Object[])new Object[]{DeleteDestination.this.getName()});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                context.out.println("Queue " + DeleteDestination.this.getName() + " deleted successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((org.apache.activemq.artemis.api.core.Message)reply, String.class);
                context.err.println("Failed to delete queue " + DeleteDestination.this.getName() + ". Reason: " + errMsg);
            }
        });
    }
}

