/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.jgroups.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.Addressable;
import org.wildfly.clustering.server.group.AddressSerializer;

public class AddressableNode
implements Node,
Addressable,
Comparable<AddressableNode>,
Serializable {
    private static final long serialVersionUID = -7707210981640344598L;
    private transient Address address;
    private final String name;
    private final InetSocketAddress socketAddress;

    public AddressableNode(Address address, String name, InetSocketAddress socketAddress) {
        this.address = address;
        this.name = name;
        this.socketAddress = socketAddress;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public int compareTo(AddressableNode node) {
        return this.address.compareTo((Object)node.address);
    }

    public boolean equals(Object object) {
        if (object instanceof Addressable) {
            Addressable node = (Addressable)object;
            return this.address.equals(node.getAddress());
        }
        return false;
    }

    public String toString() {
        return this.address.toString();
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        AddressSerializer.INSTANCE.write((DataOutput)output, this.address);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.address = AddressSerializer.INSTANCE.read(input);
    }
}

