/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryListener;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.CacheRegistryFilter;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheRegistry<K, V>
implements Registry<K, V>,
KeyFilter<Object> {
    private final ExecutorService topologyChangeExecutor = Executors.newSingleThreadExecutor(CacheRegistry.createThreadFactory(this.getClass()));
    private final Map<RegistryListener<K, V>, ExecutorService> listeners = new ConcurrentHashMap<RegistryListener<K, V>, ExecutorService>();
    private final Cache<Node, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final org.wildfly.clustering.server.group.Group<Address> group;
    private final Runnable closeTask;
    private final Map.Entry<K, V> entry;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), AccessController.doPrivileged(() -> targetClass.getClassLoader()));
    }

    public CacheRegistry(CacheRegistryConfiguration<K, V> config, Map.Entry<K, V> entry, Runnable closeTask) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.closeTask = closeTask;
        this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(entry);
        this.populateRegistry();
        this.cache.addListener((Object)this, (KeyFilter)new CacheRegistryFilter());
    }

    private void populateRegistry() {
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)this.group.getLocalMember(), this.entry);
        }
    }

    public boolean accept(Object key) {
        return key instanceof Node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.cache.removeListener((Object)this);
        this.shutdown(this.topologyChangeExecutor);
        Node node = this.getGroup().getLocalMember();
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove((Object)node);
        }
        catch (CacheException e) {
            ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.listeners.values().forEach(executor -> this.shutdown((ExecutorService)executor));
            this.listeners.clear();
            this.closeTask.run();
        }
    }

    public Registration register(RegistryListener<K, V> listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(CacheRegistry.createThreadFactory(listener.getClass())));
        return () -> this.unregister(listener);
    }

    private void unregister(RegistryListener<K, V> listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    @Deprecated
    public void removeListener(Registry.Listener<K, V> listener) {
        this.unregister((RegistryListener<K, V>)listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        HashSet nodes = new HashSet(this.group.getMembership().getMembers());
        HashMap result = new HashMap();
        try (Batch batch = this.batcher.createBatch();){
            for (Map.Entry entry : this.cache.getAdvancedCache().getAll(nodes).values()) {
                if (entry == null) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Map.Entry<K, V> getEntry(Node node) {
        try (Batch batch = this.batcher.createBatch();){
            Map.Entry entry = (Map.Entry)this.cache.get((Object)node);
            return entry;
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Node, Map.Entry<K, V>> event) {
        if (event.isPre()) {
            return;
        }
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        Address localAddress = event.getCache().getCacheManager().getAddress();
        HashSet addresses = new HashSet(previousMembers);
        addresses.removeAll(members);
        try {
            this.topologyChangeExecutor.submit(() -> {
                if (!addresses.isEmpty()) {
                    ConsistentHashLocality locality = new ConsistentHashLocality(event.getCache(), hash);
                    List<Node> nodes = addresses.stream().filter(arg_0 -> CacheRegistry.lambda$null$5((Locality)locality, arg_0)).map(address -> this.group.createNode(address)).collect(Collectors.toList());
                    if (!nodes.isEmpty()) {
                        AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                        HashMap removed = new HashMap();
                        try (Batch batch = this.batcher.createBatch();){
                            for (Node node : nodes) {
                                Map.Entry old = (Map.Entry)cache.remove((Object)node);
                                if (old == null) continue;
                                removed.put(old.getKey(), old.getValue());
                            }
                        }
                        catch (CacheException e) {
                            ClusteringServerLogger.ROOT_LOGGER.registryPurgeFailed(e, this.cache.getCacheManager().toString(), this.cache.getName(), nodes);
                        }
                        if (!removed.isEmpty()) {
                            this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
                        }
                    }
                } else if (!previousMembers.contains(localAddress)) {
                    try {
                        this.populateRegistry();
                        this.notifyListeners(Event.Type.CACHE_ENTRY_CREATED, this.entry);
                    }
                    catch (CacheException e) {
                        ClusteringServerLogger.ROOT_LOGGER.failedToRestoreLocalRegistryEntry(e, this.cache.getCacheManager().toString(), this.cache.getName());
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void event(CacheEntryEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Map.Entry<RegistryListener<K, V>, ExecutorService> entry : this.listeners.entrySet()) {
            RegistryListener<K, V> listener = entry.getKey();
            ExecutorService executor = entry.getValue();
            try {
                executor.submit(() -> {
                    try {
                        switch (type) {
                            case CACHE_ENTRY_CREATED: {
                                listener.addedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_MODIFIED: {
                                listener.updatedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_REMOVED: {
                                listener.removedEntries(entries);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(type.name());
                            }
                        }
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.registryListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), this.cache.getName(), type, entries);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void shutdown(ExecutorService executor) {
        PrivilegedAction<List> action = () -> executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static /* synthetic */ boolean lambda$null$5(Locality locality, Address address) {
        return locality.isLocal((Object)address);
    }
}

