/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.jboss.security.plugins.JBossAuthenticationManager;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreatingPolicyInterceptor;

public class AuthenticationMgrSubjectCreatingInterceptor
extends SubjectCreatingPolicyInterceptor {
    @Override
    public void handleMessage(Message message) throws Fault {
        JBossAuthenticationManager authenticationManger = (JBossAuthenticationManager)message.get(JBossAuthenticationManager.class);
        if (authenticationManger == null) {
            return;
        }
        SecurityContext context = (SecurityContext)message.get(SecurityContext.class);
        if (context == null || context.getUserPrincipal() == null) {
            Loggers.SECURITY_LOGGER.userPrincipalNotAvailableOnCurrentMessage();
            return;
        }
        SecurityToken token = (SecurityToken)message.get(SecurityToken.class);
        Subject subject = null;
        if (token != null) {
            if (token.getTokenType() != TokenType.UsernameToken) {
                throw Messages.MESSAGES.unsupportedTokenType((Object)token.getTokenType());
            }
            UsernameToken ut = (UsernameToken)token;
            subject = this.helper.createSubject(authenticationManger, ut.getName(), ut.getPassword(), ut.isHashed(), ut.getNonce(), ut.getCreatedTime());
        } else {
            Principal p = context.getUserPrincipal();
            if (!(p instanceof UsernameTokenPrincipal)) {
                throw Messages.MESSAGES.couldNotGetSubjectInfo();
            }
            UsernameTokenPrincipal up = (UsernameTokenPrincipal)p;
            subject = this.helper.createSubject(authenticationManger, up.getName(), up.getPassword(), up.isPasswordDigest(), up.getNonce(), up.getCreatedTime());
        }
        Principal principal = this.getPrincipal(context.getUserPrincipal(), subject);
        message.put(SecurityContext.class, (Object)this.createSecurityContext(principal, subject));
    }
}

