/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.function.RemovableFunction;

public class EncoderKeyMapper<K>
implements RemovableFunction<K, K> {
    private final DataConversion dataConversion;

    public EncoderKeyMapper(DataConversion dataConversion) {
        this.dataConversion = dataConversion;
    }

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.dataConversion);
    }

    @Override
    public K apply(K k) {
        return (K)this.dataConversion.fromStorage(k);
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderKeyMapper> {
        public Set<Class<? extends EncoderKeyMapper>> getTypeClasses() {
            return Collections.singleton(EncoderKeyMapper.class);
        }

        public Integer getId() {
            return 122;
        }

        public void writeObject(ObjectOutput output, EncoderKeyMapper object) throws IOException {
            output.writeObject(object.dataConversion);
        }

        public EncoderKeyMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderKeyMapper((DataConversion)input.readObject());
        }
    }
}

