/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.TxReadOnlyKeyCommand;
import org.infinispan.commands.functional.TxReadOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.BackupPutMapRpcCommand;
import org.infinispan.commands.write.BackupWriteRpcCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.InvalidateVersionsCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.ReplicableCommandManagerFunction;
import org.infinispan.manager.impl.ReplicableCommandRunnable;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.StreamSegmentResponseCommand;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    private EmbeddedCacheManager cacheManager;
    private Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, byte type) {
        ReplicableCommand command;
        block32: {
            block31: {
                if (type != 0) break block31;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block32;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block32;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block32;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block32;
                    }
                    case 68: {
                        command = new ComputeCommand();
                        break block32;
                    }
                    case 69: {
                        command = new ComputeIfAbsentCommand();
                        break block32;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block32;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block32;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block32;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block32;
                    }
                    case 17: {
                        command = new CacheTopologyControlCommand();
                        break block32;
                    }
                    case 43: {
                        command = new GetKeysInGroupCommand();
                        break block32;
                    }
                    case 45: {
                        command = new GetCacheEntryCommand();
                        break block32;
                    }
                    case 50: {
                        command = new ReadWriteKeyCommand();
                        break block32;
                    }
                    case 51: {
                        command = new ReadWriteKeyValueCommand();
                        break block32;
                    }
                    case 52: {
                        command = new ReadWriteManyCommand();
                        break block32;
                    }
                    case 53: {
                        command = new ReadWriteManyEntriesCommand();
                        break block32;
                    }
                    case 54: {
                        command = new WriteOnlyKeyCommand();
                        break block32;
                    }
                    case 55: {
                        command = new WriteOnlyKeyValueCommand();
                        break block32;
                    }
                    case 56: {
                        command = new WriteOnlyManyCommand();
                        break block32;
                    }
                    case 57: {
                        command = new WriteOnlyManyEntriesCommand();
                        break block32;
                    }
                    case 58: {
                        command = new RemoveExpiredCommand();
                        break block32;
                    }
                    case 59: {
                        command = new ReplicableCommandRunnable();
                        break block32;
                    }
                    case 60: {
                        command = new ReplicableCommandManagerFunction();
                        break block32;
                    }
                    case 62: {
                        command = new ReadOnlyKeyCommand();
                        break block32;
                    }
                    case 63: {
                        command = new ReadOnlyManyCommand();
                        break block32;
                    }
                    case 64: {
                        command = new TxReadOnlyKeyCommand();
                        break block32;
                    }
                    case 65: {
                        command = new TxReadOnlyManyCommand();
                        break block32;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }

    public CacheRpcCommand fromStream(byte id, byte type, ByteString cacheName) {
        CacheRpcCommand command;
        block38: {
            block37: {
                if (type != 0) break block37;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block38;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block38;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block38;
                    }
                    case 38: {
                        command = new TotalOrderNonVersionedPrepareCommand(cacheName);
                        break block38;
                    }
                    case 39: {
                        command = new TotalOrderVersionedPrepareCommand(cacheName);
                        break block38;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block38;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block38;
                    }
                    case 35: {
                        command = new TotalOrderCommitCommand(cacheName);
                        break block38;
                    }
                    case 36: {
                        command = new TotalOrderVersionedCommitCommand(cacheName);
                        break block38;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block38;
                    }
                    case 37: {
                        command = new TotalOrderRollbackCommand(cacheName);
                        break block38;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block38;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block38;
                    }
                    case 15: {
                        command = new StateRequestCommand(cacheName);
                        break block38;
                    }
                    case 20: {
                        command = new StateResponseCommand(cacheName);
                        break block38;
                    }
                    case 18: {
                        command = new RemoveCacheCommand(cacheName, this.cacheManager);
                        break block38;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block38;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block38;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand(cacheName);
                        break block38;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block38;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block38;
                    }
                    case 29: {
                        command = new CreateCacheCommand(cacheName);
                        break block38;
                    }
                    case 32: {
                        command = new XSiteAdminCommand(cacheName);
                        break block38;
                    }
                    case 34: {
                        command = new CancelCommand(cacheName);
                        break block38;
                    }
                    case 28: {
                        command = new XSiteStateTransferControlCommand(cacheName);
                        break block38;
                    }
                    case 33: {
                        command = new XSiteStatePushCommand(cacheName);
                        break block38;
                    }
                    case 40: {
                        command = new SingleXSiteRpcCommand(cacheName);
                        break block38;
                    }
                    case 46: {
                        command = new ClusteredGetAllCommand(cacheName);
                        break block38;
                    }
                    case 47: {
                        command = new StreamRequestCommand(cacheName);
                        break block38;
                    }
                    case 49: {
                        command = new StreamSegmentResponseCommand(cacheName);
                        break block38;
                    }
                    case 48: {
                        command = new StreamResponseCommand(cacheName);
                        break block38;
                    }
                    case 61: {
                        command = new BackupWriteRpcCommand(cacheName);
                        break block38;
                    }
                    case 66: {
                        command = new BackupPutMapRpcCommand(cacheName);
                        break block38;
                    }
                    case 67: {
                        command = new InvalidateVersionsCommand(cacheName);
                        break block38;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }
}

