/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractComponentFactory {
    protected GlobalComponentRegistry globalComponentRegistry;
    protected GlobalConfiguration globalConfiguration;

    @Inject
    private void injectGlobalDependencies(GlobalConfiguration globalConfiguration, GlobalComponentRegistry globalComponentRegistry) {
        this.globalComponentRegistry = globalComponentRegistry;
        this.globalConfiguration = globalConfiguration;
    }

    public abstract <T> T construct(Class<T> var1);

    protected void assertTypeConstructable(Class<?> requestedType, Class<?> ... ableToConstruct) {
        boolean canConstruct = false;
        for (Class<?> c : ableToConstruct) {
            canConstruct = canConstruct || requestedType.isAssignableFrom(c);
        }
        if (!canConstruct) {
            throw new CacheConfigurationException("Don't know how to construct " + requestedType);
        }
    }
}

