/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.SimpleClusteredVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@DefaultFactoryFor(classes={VersionGenerator.class})
@Scope(value=Scopes.NAMED_CACHE)
public class VersionGeneratorFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    private Configuration configuration;

    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        if ("org.infinispan.transaction.versionGenerator".endsWith(componentName)) {
            return componentType.cast(new NumericVersionGenerator());
        }
        if (Configurations.isTxVersioned(this.configuration)) {
            return this.configuration.clustering().cacheMode().isClustered() ? componentType.cast(new SimpleClusteredVersionGenerator()) : componentType.cast(new NumericVersionGenerator());
        }
        return componentType.cast(new NumericVersionGenerator());
    }

    @Inject
    private void injectGlobalDependencies(Configuration configuration) {
        this.configuration = configuration;
    }
}

