/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.classloading.impl.DefaultClassLoaderService;

public class DelegatingClassLoaderService
implements org.hibernate.search.engine.service.classloading.spi.ClassLoaderService {
    private final ClassLoaderService hibernateClassLoaderService;
    private final org.hibernate.search.engine.service.classloading.spi.ClassLoaderService internalClassLoaderService;

    public DelegatingClassLoaderService(ClassLoaderService hibernateClassLoaderService) {
        this.hibernateClassLoaderService = hibernateClassLoaderService;
        this.internalClassLoaderService = new DefaultClassLoaderService();
    }

    public <T> Class<T> classForName(String className) {
        try {
            return this.hibernateClassLoaderService.classForName(className);
        }
        catch (ClassLoadingException e) {
            return this.internalClassLoaderService.classForName(className);
        }
    }

    public URL locateResource(String name) {
        URL url = this.hibernateClassLoaderService.locateResource(name);
        if (url == null) {
            url = this.internalClassLoaderService.locateResource(name);
        }
        return url;
    }

    public InputStream locateResourceStream(String name) {
        InputStream in = this.hibernateClassLoaderService.locateResourceStream(name);
        if (in == null) {
            in = this.internalClassLoaderService.locateResourceStream(name);
        }
        return in;
    }

    public <T> Iterable<T> loadJavaServices(Class<T> serviceContract) {
        Collection servicesFromORMCLassLoader = this.hibernateClassLoaderService.loadJavaServices(serviceContract);
        Iterable servicesFromLocalClassLoader = this.internalClassLoaderService.loadJavaServices(serviceContract);
        LinkedHashMap combined = new LinkedHashMap();
        this.addAllServices(servicesFromORMCLassLoader, combined);
        this.addAllServices(servicesFromLocalClassLoader, combined);
        return combined.values();
    }

    private <T> void addAllServices(Iterable<T> services, Map<String, T> combined) {
        for (T service : services) {
            combined.put(service.getClass().getName(), service);
        }
    }
}

