/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;

public class ActiveMQStompProtocolMessageBundle_$bundle
implements ActiveMQStompProtocolMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQStompProtocolMessageBundle_$bundle INSTANCE = new ActiveMQStompProtocolMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQStompProtocolMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String negativeConnectionTTL$str() {
        return "AMQ339000: Stomp Connection TTL cannot be negative: {0}";
    }

    @Override
    public final IllegalStateException negativeConnectionTTL(Long ttl) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.negativeConnectionTTL$str(), ttl));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String destinationNotExist$str() {
        return "AMQ339001: Destination does not exist: {0}";
    }

    @Override
    public final ActiveMQStompException destinationNotExist(String destination) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.destinationNotExist$str(), destination));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String versionNotSupported$str() {
        return "AMQ339002: Stomp versions not supported: {0}";
    }

    @Override
    public final ActiveMQStompException versionNotSupported(String acceptVersion) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.versionNotSupported$str(), acceptVersion));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullHostHeader$str() {
        return "AMQ339003: Header host is null";
    }

    @Override
    public final ActiveMQStompException nullHostHeader() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.nullHostHeader$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostCannotBeNull$str() {
        return "AMQ339004: Cannot accept null as host";
    }

    @Override
    public final String hostCannotBeNull() {
        return String.format(this.getLoggingLocale(), this.hostCannotBeNull$str(), new Object[0]);
    }

    protected String hostNotMatch$str() {
        return "AMQ339005: Header host does not match server host";
    }

    @Override
    public final ActiveMQStompException hostNotMatch() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.hostNotMatch$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostNotMatchDetails$str() {
        return "AMQ339006: host {0} does not match server host name";
    }

    @Override
    public final String hostNotMatchDetails(String host) {
        return this._formatMessage(this.hostNotMatchDetails$str(), host);
    }

    protected String connectionDestroyed$str() {
        return "AMQ339007: Connection was destroyed.";
    }

    @Override
    public final ActiveMQStompException connectionDestroyed() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.connectionDestroyed$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionNotEstablished$str() {
        return "AMQ339008: Connection has not been established.";
    }

    @Override
    public final ActiveMQStompException connectionNotEstablished() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.connectionNotEstablished$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorGetSession$str() {
        return "AMQ339009: Exception getting session";
    }

    @Override
    public final ActiveMQStompException errorGetSession(Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.errorGetSession$str(), new Object[0]), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConnection$str() {
        return "AMQ339010: Connection is not valid.";
    }

    @Override
    public final ActiveMQStompException invalidConnection() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.invalidConnection$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorSendMessage$str() {
        return "AMQ339011: Error sending message {0}";
    }

    @Override
    public final ActiveMQStompException errorSendMessage(Message message, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorSendMessage$str(), message), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorBeginTx$str() {
        return "AMQ339012: Error beginning a transaction {0}";
    }

    @Override
    public final ActiveMQStompException errorBeginTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorBeginTx$str(), txID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCommitTx$str() {
        return "AMQ339013: Error committing {0}";
    }

    @Override
    public final ActiveMQStompException errorCommitTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorCommitTx$str(), txID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorAbortTx$str() {
        return "AMQ339014: Error aborting {0}";
    }

    @Override
    public final ActiveMQStompException errorAbortTx(String txID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorAbortTx$str(), txID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDestination$str() {
        return "AMQ339015: Client must set destination or id header to a SUBSCRIBE command";
    }

    @Override
    public final ActiveMQStompException noDestination() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.noDestination$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCreatingSubscription$str() {
        return "AMQ339016: Error creating subscription {0}";
    }

    @Override
    public final ActiveMQStompException errorCreatingSubscription(String subscriptionID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorCreatingSubscription$str(), subscriptionID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorUnsubscribing$str() {
        return "AMQ339017: Error unsubscribing {0}";
    }

    @Override
    public final ActiveMQStompException errorUnsubscribing(String subscriptionID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorUnsubscribing$str(), subscriptionID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorAck$str() {
        return "AMQ339018: Error acknowledging message {0}";
    }

    @Override
    public final ActiveMQStompException errorAck(String messageID, Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.errorAck$str(), messageID), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTwoCRs$str() {
        return "AMQ339019: Invalid char sequence: two consecutive CRs.";
    }

    @Override
    public final ActiveMQStompException invalidTwoCRs() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.invalidTwoCRs$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badCRs$str() {
        return "AMQ339020: Invalid char sequence: There is a CR not followed by an LF";
    }

    @Override
    public final ActiveMQStompException badCRs() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.badCRs$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notValidNewLine$str() {
        return "AMQ339021: Expect new line char but is {0}";
    }

    @Override
    public final ActiveMQStompException notValidNewLine(byte b) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.notValidNewLine$str(), b));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedNewLine$str() {
        return "AMQ339022: Expect new line char but is {0}";
    }

    @Override
    public final String unexpectedNewLine(byte b) {
        return this._formatMessage(this.unexpectedNewLine$str(), b);
    }

    protected String invalidCommand$str() {
        return "AMQ339023: Invalid STOMP frame: {0}";
    }

    @Override
    public final ActiveMQStompException invalidCommand(String dumpByteArray) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.invalidCommand$str(), dumpByteArray));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFrame$str() {
        return "AMQ339024: Invalid STOMP frame: {0}";
    }

    @Override
    public final String invalidFrame(String dumpByteArray) {
        return this._formatMessage(this.invalidFrame$str(), dumpByteArray);
    }

    protected String failToAckMissingID$str() {
        return "AMQ339025: failed to ack because no message with id: {0}";
    }

    @Override
    public final ActiveMQStompException failToAckMissingID(long id) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.failToAckMissingID$str(), id));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String subscriptionIDMismatch$str() {
        return "AMQ339026: subscription id {0} does not match {1}";
    }

    @Override
    public final ActiveMQStompException subscriptionIDMismatch(String subscriptionID, String actualID) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.subscriptionIDMismatch$str(), subscriptionID, actualID));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingClientID$str() {
        return "AMQ339027: Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
    }

    @Override
    public final IllegalStateException missingClientID() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingClientID$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String headerTooBig$str() {
        return "AMQ339028: Message header too big, increase minLargeMessageSize please.";
    }

    @Override
    public final Exception headerTooBig() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.headerTooBig$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCommand$str() {
        return "AMQ339029: Unsupported command: {0}";
    }

    @Override
    public final ActiveMQStompException unknownCommand(String command) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.unknownCommand$str(), command));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String needTxIDHeader$str() {
        return "AMQ339030: transaction header is mandatory to COMMIT a transaction";
    }

    @Override
    public final ActiveMQStompException needTxIDHeader() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.needTxIDHeader$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorHandleSend$str() {
        return "AMQ339031: Error handling send";
    }

    @Override
    public final ActiveMQStompException errorHandleSend(Exception e) {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.errorHandleSend$str(), new Object[0]), e);
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beginTxNoID$str() {
        return "AMQ339032: Need a transaction id to begin";
    }

    @Override
    public final ActiveMQStompException beginTxNoID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.beginTxNoID$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String abortTxNoID$str() {
        return "AMQ339033: transaction header is mandatory to ABORT a transaction";
    }

    @Override
    public final ActiveMQStompException abortTxNoID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.abortTxNoID$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCall$str() {
        return "AMQ339034: This method should not be called";
    }

    @Override
    public final IllegalStateException invalidCall() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidCall$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String needIDorDestination$str() {
        return "AMQ339035: Must specify the subscription''s id or the destination you are unsubscribing from";
    }

    @Override
    public final ActiveMQStompException needIDorDestination() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.needIDorDestination$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String needSubscriptionID$str() {
        return "AMQ339037: Must specify the subscription''s id";
    }

    @Override
    public final ActiveMQStompException needSubscriptionID() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.needSubscriptionID$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noIDInAck$str() {
        return "AMQ339039: No id header in ACK/NACK frame.";
    }

    @Override
    public final ActiveMQStompException noIDInAck() {
        ActiveMQStompException result = new ActiveMQStompException(String.format(this.getLoggingLocale(), this.noIDInAck$str(), new Object[0]));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String undefinedEscapeSequence$str() {
        return "AMQ339040: Undefined escape sequence: {0}";
    }

    @Override
    public final ActiveMQStompException undefinedEscapeSequence(String sequence) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.undefinedEscapeSequence$str(), sequence));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalSemantics$str() {
        return "AMQ339041: Not allowed to specify {0} semantics on {1} address.";
    }

    @Override
    public final ActiveMQStompException illegalSemantics(String requested, String exists) {
        ActiveMQStompException result = new ActiveMQStompException(this._formatMessage(this.illegalSemantics$str(), requested, exists));
        ActiveMQStompProtocolMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

