/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.parsing.DomainXml;
import org.jboss.as.host.controller.parsing.HostXml;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ConfigurationPersisterFactory {
    static final String CACHED_DOMAIN_XML = "domain.cached-remote.xml";
    static final String CACHED_DOMAIN_XML_BOOTFILE = "domain.cached-remote.xml.boot";

    public static ExtensibleConfigurationPersister createHostXmlConfigurationPersister(ConfigurationFile file, HostControllerEnvironment environment, ExecutorService executorService, ExtensionRegistry hostExtensionRegistry, LocalHostControllerInfo localHostControllerInfo) {
        String defaultHostname = localHostControllerInfo.getLocalHostName();
        if (environment.getRunningModeControl().isReloaded() && environment.getRunningModeControl().getReloadHostName() != null) {
            defaultHostname = environment.getRunningModeControl().getReloadHostName();
        }
        HostXml hostXml = new HostXml(defaultHostname, environment.getRunningModeControl().getRunningMode(), environment.isUseCachedDc(), Module.getBootModuleLoader(), executorService, hostExtensionRegistry);
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "host"), (XMLElementReader)hostXml, (XMLElementWriter)hostXml, false);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "host"), (XMLElementReader)hostXml);
        }
        hostExtensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(ConfigurationFile file, ExecutorService executorService, ExtensionRegistry extensionRegistry, HostControllerEnvironment environment) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        boolean suppressLoad = false;
        ConfigurationFile.InteractionPolicy policy = file.getInteractionPolicy();
        boolean isReloaded = environment.getRunningModeControl().isReloaded();
        if (!isReloaded && policy == ConfigurationFile.InteractionPolicy.NEW && file.getBootFile().exists() && file.getBootFile().length() != 0L) {
            throw HostControllerLogger.ROOT_LOGGER.cannotOverwriteDomainXmlWithEmpty(file.getBootFile().getName());
        }
        if (!(isReloaded || policy != ConfigurationFile.InteractionPolicy.NEW && policy != ConfigurationFile.InteractionPolicy.DISCARD)) {
            suppressLoad = true;
        }
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml, suppressLoad);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "domain"), (XMLElementReader)domainXml);
        }
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createRemoteBackupDomainXmlConfigurationPersister(File configDir, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        File bootFile = new File(configDir, CACHED_DOMAIN_XML_BOOTFILE);
        File file = new File(configDir, CACHED_DOMAIN_XML);
        BackupRemoteDomainXmlPersister persister = new BackupRemoteDomainXmlPersister(file, bootFile, new QName(Namespace.CURRENT.getUriString(), "domain"), domainXml, domainXml);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "domain"), domainXml);
        }
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createCachedRemoteDomainXmlConfigurationPersister(File configDir, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        return ConfigurationPersisterFactory.createRemoteBackupDomainXmlConfigurationPersister(configDir, executorService, extensionRegistry);
    }

    public static ExtensibleConfigurationPersister createTransientDomainXmlConfigurationPersister(ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        NullConfigurationPersister persister = new NullConfigurationPersister((XMLElementWriter)domainXml);
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    static class BackupRemoteDomainXmlPersister
    extends XmlConfigurationPersister {
        private final AtomicBoolean successfulBoot = new AtomicBoolean();
        private File file;
        private File bootFile;
        private XmlConfigurationPersister bootWriter;

        BackupRemoteDomainXmlPersister(File file, File bootFile, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
            super(file, rootElement, rootParser, rootDeparser);
            this.bootWriter = new XmlConfigurationPersister(bootFile, rootElement, rootParser, rootDeparser);
            this.file = file;
            this.bootFile = bootFile;
        }

        public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
            this.bootWriter.registerAdditionalRootElement(anotherRoot, parser);
            super.registerAdditionalRootElement(anotherRoot, parser);
        }

        public void registerSubsystemWriter(String name, Supplier<XMLElementWriter<SubsystemMarshallingContext>> writer) {
            this.bootWriter.registerSubsystemWriter(name, writer);
            super.registerSubsystemWriter(name, writer);
        }

        public void unregisterSubsystemWriter(String name) {
            this.bootWriter.unregisterSubsystemWriter(name);
            super.unregisterSubsystemWriter(name);
        }

        public List<ModelNode> load() throws ConfigurationPersistenceException {
            try {
                return super.load();
            }
            catch (ConfigurationPersistenceException e) {
                HostControllerLogger.ROOT_LOGGER.invalidRemoteBackupPersisterState();
                throw e;
            }
        }

        public void successfulBoot() throws ConfigurationPersistenceException {
            if (this.successfulBoot.compareAndSet(false, true)) {
                try {
                    Files.move(this.bootFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.cannotRenameCachedDomainXmlOnBoot(this.bootFile.getName(), this.file.getName(), e.getMessage());
                    throw new ConfigurationPersistenceException((Throwable)e);
                }
            }
        }

        public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
            if (!this.successfulBoot.get()) {
                return this.bootWriter.store(model, affectedAddresses);
            }
            return super.store(model, affectedAddresses);
        }
    }
}

