/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.DeploymentServletDefinition;
import org.wildfly.extension.undertow.DeploymentWebSocketDefinition;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowSubsystemModel;
import org.wildfly.extension.undertow.UndertowSubsystemSchema;

public class UndertowExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "undertow";
    private static final String RESOURCE_NAME = UndertowExtension.class.getPackage().getName() + ".LocalDescriptions";
    private final PersistentResourceXMLDescription currentDescription = UndertowSubsystemSchema.CURRENT.getXMLDescription();

    public static StandardResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, UndertowExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (UndertowSubsystemSchema schema : EnumSet.allOf(UndertowSubsystemSchema.class)) {
            UndertowSubsystemSchema reader = schema == UndertowSubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, UndertowSubsystemModel.CURRENT.getVersion());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new UndertowRootDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, false);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)new DeploymentDefinition());
        deployments.registerSubModel((ResourceDefinition)new DeploymentServletDefinition());
        deployments.registerSubModel((ResourceDefinition)new DeploymentWebSocketDefinition());
        subsystem.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
    }
}

