/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.jboss.as.service.DelegatingSupplier;
import org.jboss.as.service.ReflectionUtils;

final class PropertySupplier
extends DelegatingSupplier {
    private final String propertyName;

    PropertySupplier(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Object get() {
        Supplier objectSupplier = this.objectSupplier;
        if (objectSupplier == null) {
            throw new IllegalStateException("Object supplier not available");
        }
        Object o = objectSupplier.get();
        if (o == null) {
            throw new IllegalStateException("Object not available");
        }
        if (this.propertyName != null) {
            try {
                return ReflectionUtils.getGetter(o.getClass(), this.propertyName).invoke(o, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Method is not accessible", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Failed to invoke method", e);
            }
        }
        return o;
    }
}

