/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV3;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AMQPStandardMessage
extends AMQPMessage {
    protected ReadableBuffer data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPStandardMessage createMessage(long messageID, long messageFormat, SimpleString replyTo, Header header, Properties properties, Map<Symbol, Object> daMap, Map<Symbol, Object> maMap, Map<String, Object> apMap, Map<Symbol, Object> footerMap, Section body) {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            if (header != null) {
                encoder.writeObject((Object)header);
            }
            if (daMap != null) {
                encoder.writeObject((Object)new DeliveryAnnotations(daMap));
            }
            if (maMap != null) {
                encoder.writeObject((Object)new MessageAnnotations(maMap));
            }
            if (properties != null) {
                encoder.writeObject((Object)properties);
            }
            if (apMap != null) {
                encoder.writeObject((Object)new ApplicationProperties(apMap));
            }
            if (body != null) {
                encoder.writeObject((Object)body);
            }
            if (footerMap != null) {
                encoder.writeObject((Object)new Footer(footerMap));
            }
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage amqpMessage = new AMQPStandardMessage(messageFormat, data, null);
            amqpMessage.setMessageID(messageID);
            amqpMessage.setReplyTo(replyTo);
            AMQPStandardMessage aMQPStandardMessage = amqpMessage;
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    public AMQPStandardMessage(long messageFormat, byte[] data, TypedProperties extraProperties) {
        this(messageFormat, data, extraProperties, null);
    }

    public AMQPStandardMessage(long messageFormat, byte[] data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this(messageFormat, (ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((byte[])data), extraProperties, coreMessageObjectPools);
    }

    public AMQPStandardMessage(long messageFormat, ReadableBuffer data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        super(messageFormat, extraProperties, coreMessageObjectPools);
        this.data = data;
        this.ensureMessageDataScanned();
    }

    AMQPStandardMessage(long messageFormat) {
        super(messageFormat);
    }

    @Override
    public Message copy() {
        this.ensureDataIsValid();
        ReadableBuffer view = this.data.duplicate().rewind();
        byte[] newData = new byte[view.remaining()];
        view.get(newData);
        AMQPStandardMessage newEncode = new AMQPStandardMessage(this.messageFormat, newData, this.extraProperties, this.coreMessageObjectPools);
        newEncode.setMessageID(this.getMessageID());
        return newEncode;
    }

    @Override
    public int getEncodeSize() {
        this.ensureDataIsValid();
        return this.data.remaining() - this.encodedDeliveryAnnotationsSize + this.getDeliveryAnnotationsForSendBufferSize();
    }

    @Override
    protected ReadableBuffer getData() {
        return this.data;
    }

    @Override
    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.data != null ? this.data.capacity() + this.unmarshalledApplicationPropertiesMemoryEstimateFromData(this.data) : 0);
        }
        return this.memoryEstimate;
    }

    @Override
    public void persist(ActiveMQBuffer targetRecord) {
        this.ensureDataIsValid();
        targetRecord.writeInt(this.internalPersistSize());
        if (this.data.hasArray()) {
            targetRecord.writeBytes(this.data.array(), this.data.arrayOffset(), this.data.remaining());
        } else {
            targetRecord.writeBytes(this.data.byteBuffer());
        }
    }

    public final Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    @Override
    public int getPersistSize() {
        this.ensureDataIsValid();
        return 4 + this.internalPersistSize();
    }

    @Override
    public void reloadPersistence(ActiveMQBuffer record, CoreMessageObjectPools pools) {
        int size = record.readInt();
        byte[] recordArray = new byte[size];
        record.readBytes(recordArray);
        this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(recordArray));
        this.resetMessageData();
        this.modified = false;
        this.messageDataScanned = AMQPMessage.MessageDataScanningStatus.RELOAD_PERSISTENCE.code;
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    @Override
    public Persister<Message> getPersister() {
        return AMQPMessagePersisterV3.getInstance();
    }

    @Override
    public void reencode() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.address != null) {
            this.properties.setTo(this.address.toString());
        }
        this.encodeMessage();
        this.scanMessageData();
    }

    @Override
    protected synchronized void ensureDataIsValid() {
        if (this.modified) {
            this.encodeMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void encodeMessage() {
        this.modified = false;
        this.messageDataScanned = AMQPMessage.MessageDataScanningStatus.NOT_SCANNED.code;
        int estimated = Math.max(1500, this.data != null ? this.data.capacity() + 1000 : 0);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(estimated);
        EncoderImpl encoder = TLSEncode.getEncoder();
        try {
            NettyWritable writable = new NettyWritable(buffer);
            encoder.setByteBuffer((WritableBuffer)writable);
            if (this.header != null) {
                encoder.writeObject((Object)this.header);
            }
            if (this.messageAnnotations != null) {
                encoder.writeObject((Object)this.messageAnnotations);
            }
            if (this.properties != null) {
                encoder.writeObject((Object)this.properties);
            }
            if (this.applicationProperties != null) {
                encoder.writeObject((Object)this.applicationProperties);
                if (this.data != null && this.remainingBodyPosition != -1) {
                    writable.put(this.data.position(this.remainingBodyPosition));
                }
            } else if (this.data != null && this.applicationPropertiesPosition != -1) {
                writable.put(this.data.position(this.applicationPropertiesPosition));
            } else if (this.data != null && this.remainingBodyPosition != -1) {
                writable.put(this.data.position(this.remainingBodyPosition));
            }
            byte[] bytes = new byte[buffer.writerIndex()];
            buffer.readBytes(bytes);
            this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(bytes));
        }
        finally {
            encoder.setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    @Override
    public String toString() {
        this.ensureScanning();
        return super.toString();
    }

    public String getStringBody() {
        Section body = this.getBody();
        if (body instanceof AmqpValue && ((AmqpValue)body).getValue() instanceof String) {
            return (String)((AmqpValue)body).getValue();
        }
        return null;
    }
}

