/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.util.UtilLogging;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class FilterUtil {
    private final Map<Object, Object> stack = new IdentityHashMap<Object, Object>();

    private FilterUtil() {
    }

    public static final OpenAPI applyFilter(OASFilter filter, OpenAPI model) {
        return new FilterUtil().filter(filter, model);
    }

    private OpenAPI filter(OASFilter filter, OpenAPI model) {
        this.filterComponents(filter, model.getComponents());
        if (model.getPaths() != null) {
            this.filter(filter, (Object)model.getPaths().getPathItems(), (BiConsumer)this::filterPathItem, arg_0 -> ((OASFilter)filter).filterPathItem(arg_0), arg_0 -> ((Paths)model.getPaths()).removePathItem(arg_0));
        }
        this.filter(filter, (Object)model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((OpenAPI)model).removeServer(arg_0));
        this.filter(filter, (Object)model.getTags(), null, arg_0 -> ((OASFilter)filter).filterTag(arg_0), arg_0 -> ((OpenAPI)model).removeTag(arg_0));
        filter.filterOpenAPI(model);
        return model;
    }

    private void filterComponents(OASFilter filter, Components model) {
        if (model != null) {
            this.filter(filter, (Object)model.getCallbacks(), (BiConsumer)this::filterCallback, arg_0 -> ((OASFilter)filter).filterCallback(arg_0), arg_0 -> ((Components)model).removeCallback(arg_0));
            this.filter(filter, (Object)model.getHeaders(), (BiConsumer)this::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((Components)model).removeHeader(arg_0));
            this.filter(filter, (Object)model.getLinks(), (BiConsumer)this::filterLink, arg_0 -> ((OASFilter)filter).filterLink(arg_0), arg_0 -> ((Components)model).removeLink(arg_0));
            this.filter(filter, (Object)model.getParameters(), (BiConsumer)this::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((Components)model).removeParameter(arg_0));
            this.filter(filter, (Object)model.getRequestBodies(), (BiConsumer)this::filterRequestBody, arg_0 -> ((OASFilter)filter).filterRequestBody(arg_0), arg_0 -> ((Components)model).removeRequestBody(arg_0));
            this.filter(filter, (Object)model.getResponses(), (BiConsumer)this::filterAPIResponse, arg_0 -> ((OASFilter)filter).filterAPIResponse(arg_0), arg_0 -> ((Components)model).removeResponse(arg_0));
            this.filter(filter, (Object)model.getSchemas(), (BiConsumer)this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Components)model).removeSchema(arg_0));
            this.filter(filter, (Object)model.getSecuritySchemes(), null, arg_0 -> ((OASFilter)filter).filterSecurityScheme(arg_0), arg_0 -> ((Components)model).removeSecurityScheme(arg_0));
        }
    }

    boolean push(Object model) {
        boolean cyclicReference = this.stack.containsKey(model);
        if (cyclicReference) {
            UtilLogging.logger.cylicReferenceDetected();
        } else {
            this.stack.put(model, model);
        }
        return !cyclicReference;
    }

    private <K, V> void filter(OASFilter filter, Map<K, V> models, BiConsumer<OASFilter, V> contentFilter, UnaryOperator<V> modelFilter, Consumer<K> remover) {
        if (models != null) {
            for (Map.Entry entry : new LinkedHashSet<Map.Entry<K, V>>(models.entrySet())) {
                Object model = entry.getValue();
                if (!this.push(model)) continue;
                if (contentFilter != null) {
                    contentFilter.accept(filter, model);
                }
                if (modelFilter.apply(model) == null) {
                    remover.accept(entry.getKey());
                }
                this.stack.remove(model);
            }
        }
    }

    private <T> void filter(OASFilter filter, List<T> models, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> remover) {
        if (models != null) {
            for (T model : new ArrayList<T>(models)) {
                if (!this.push(model)) continue;
                if (contentFilter != null) {
                    contentFilter.accept(filter, (OASFilter)model);
                }
                if (modelFilter.apply(model) == null) {
                    remover.accept(model);
                }
                this.stack.remove(model);
            }
        }
    }

    private <T> void filter(OASFilter filter, T model, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> mutator) {
        if (model != null) {
            if (!this.push(model)) {
                return;
            }
            if (contentFilter != null) {
                contentFilter.accept(filter, (OASFilter)model);
            }
            mutator.accept(modelFilter.apply(model));
            this.stack.remove(model);
        }
    }

    private void filterCallback(OASFilter filter, Callback model) {
        if (model != null) {
            ArrayList keys = new ArrayList(model.getPathItems().keySet());
            for (String key : keys) {
                PathItem childModel = model.getPathItem(key);
                this.filterPathItem(filter, childModel);
                if (filter.filterPathItem(childModel) != null) continue;
                model.removePathItem(key);
            }
        }
    }

    private void filterPathItem(OASFilter filter, PathItem model) {
        if (model != null) {
            this.filter(filter, (Object)model.getParameters(), (BiConsumer)this::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((PathItem)model).removeParameter(arg_0));
            this.filterOperation(filter, model.getDELETE(), arg_0 -> ((PathItem)model).setDELETE(arg_0));
            this.filterOperation(filter, model.getGET(), arg_0 -> ((PathItem)model).setGET(arg_0));
            this.filterOperation(filter, model.getHEAD(), arg_0 -> ((PathItem)model).setHEAD(arg_0));
            this.filterOperation(filter, model.getOPTIONS(), arg_0 -> ((PathItem)model).setOPTIONS(arg_0));
            this.filterOperation(filter, model.getPATCH(), arg_0 -> ((PathItem)model).setPATCH(arg_0));
            this.filterOperation(filter, model.getPOST(), arg_0 -> ((PathItem)model).setPOST(arg_0));
            this.filterOperation(filter, model.getPUT(), arg_0 -> ((PathItem)model).setPUT(arg_0));
            this.filterOperation(filter, model.getTRACE(), arg_0 -> ((PathItem)model).setTRACE(arg_0));
            this.filter(filter, (Object)model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((PathItem)model).removeServer(arg_0));
        }
    }

    private void filterOperation(OASFilter filter, Operation model, Consumer<Operation> mutator) {
        if (model != null) {
            this.filter(filter, (Object)model.getCallbacks(), (BiConsumer)this::filterCallback, arg_0 -> ((OASFilter)filter).filterCallback(arg_0), arg_0 -> ((Operation)model).removeCallback(arg_0));
            this.filter(filter, (Object)model.getParameters(), (BiConsumer)this::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((Operation)model).removeParameter(arg_0));
            this.filter(filter, model.getRequestBody(), this::filterRequestBody, arg_0 -> ((OASFilter)filter).filterRequestBody(arg_0), arg_0 -> ((Operation)model).setRequestBody(arg_0));
            if (model.getResponses() != null) {
                APIResponses responses = model.getResponses();
                this.filter(filter, (Object)responses.getAPIResponses(), (BiConsumer)this::filterAPIResponse, arg_0 -> ((OASFilter)filter).filterAPIResponse(arg_0), arg_0 -> ((APIResponses)responses).removeAPIResponse(arg_0));
            }
            this.filter(filter, (Object)model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((Operation)model).removeServer(arg_0));
            mutator.accept(filter.filterOperation(model));
        }
    }

    private void filterHeader(OASFilter filter, Header model) {
        if (model != null) {
            this.filterContent(filter, model.getContent());
            this.filter(filter, model.getSchema(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Header)model).setSchema(arg_0));
        }
    }

    private void filterContent(OASFilter filter, Content model) {
        if (model != null && model.getMediaTypes() != null) {
            ArrayList keys = new ArrayList(model.getMediaTypes().keySet());
            for (String key : keys) {
                MediaType childModel = model.getMediaType(key);
                this.filterMediaType(filter, childModel);
            }
        }
    }

    private void filterMediaType(OASFilter filter, MediaType model) {
        if (model != null) {
            this.filterEncoding(filter, model.getEncoding());
            this.filter(filter, model.getSchema(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((MediaType)model).setSchema(arg_0));
        }
    }

    private void filterEncoding(OASFilter filter, Map<String, Encoding> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Encoding model = models.get(key);
                this.filterEncoding(filter, model);
            }
        }
    }

    private void filterEncoding(OASFilter filter, Encoding model) {
        if (model != null) {
            this.filter(filter, (Object)model.getHeaders(), (BiConsumer)this::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((Encoding)model).removeHeader(arg_0));
        }
    }

    private void filterLink(OASFilter filter, Link model) {
        if (model != null && model.getServer() != null) {
            model.setServer(filter.filterServer(model.getServer()));
        }
    }

    private void filterParameter(OASFilter filter, Parameter model) {
        if (model != null) {
            this.filterContent(filter, model.getContent());
            this.filter(filter, model.getSchema(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Parameter)model).setSchema(arg_0));
        }
    }

    private void filterRequestBody(OASFilter filter, RequestBody model) {
        if (model != null) {
            this.filterContent(filter, model.getContent());
        }
    }

    private void filterAPIResponse(OASFilter filter, APIResponse model) {
        if (model != null) {
            this.filterContent(filter, model.getContent());
            this.filter(filter, (Object)model.getHeaders(), (BiConsumer)this::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((APIResponse)model).removeHeader(arg_0));
            this.filter(filter, (Object)model.getLinks(), (BiConsumer)this::filterLink, arg_0 -> ((OASFilter)filter).filterLink(arg_0), arg_0 -> ((APIResponse)model).removeLink(arg_0));
        }
    }

    private void filterSchema(OASFilter filter, Schema model) {
        if (model != null) {
            this.filter(filter, model.getAdditionalPropertiesSchema(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setAdditionalPropertiesSchema(arg_0));
            this.filter(filter, (Object)model.getAllOf(), (BiConsumer)this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeAllOf(arg_0));
            this.filter(filter, (Object)model.getAnyOf(), (BiConsumer)this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeAnyOf(arg_0));
            this.filter(filter, (Object)model.getOneOf(), (BiConsumer)this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeOneOf(arg_0));
            this.filter(filter, model.getItems(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setItems(arg_0));
            this.filter(filter, model.getNot(), this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setNot(arg_0));
            this.filter(filter, (Object)model.getProperties(), (BiConsumer)this::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeProperty(arg_0));
        }
    }
}

