/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import org.wildfly.clustering.ee.Creator;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanGroup;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;

public interface BeanFactory<K, V extends BeanInstance<K>, M>
extends ImmutableBeanFactory<K, V, M>,
Creator<V, M, K>,
Remover<K> {
    @Override
    public BeanMetaDataFactory<K, M> getMetaDataFactory();

    @Override
    public BeanGroupManager<K, V> getBeanGroupManager();

    default public M createValue(V id, K groupId) {
        return (M)this.getMetaDataFactory().createValue(id, groupId);
    }

    default public boolean remove(K id) {
        return this.getMetaDataFactory().remove(id);
    }

    default public boolean purge(K id) {
        return this.getMetaDataFactory().purge(id);
    }

    default public MutableBean<K, V> createBean(K id, M value) {
        BeanMetaData<K> metaData = this.getMetaDataFactory().createBeanMetaData(id, value);
        BeanGroup group = this.getBeanGroupManager().getBeanGroup(metaData.getGroupId());
        return this.createBean(id, metaData, group);
    }

    public MutableBean<K, V> createBean(K var1, BeanMetaData<K> var2, BeanGroup<K, V> var3);
}

