/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.orchestration.spi;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractWorkOrchestrator<W> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private State state = State.STOPPED;
    private final ReadWriteLock lifecycleLock = new ReentrantReadWriteLock();
    protected final Consumer<? super W> blockingRetryProducer = w -> this.submit(w, OperationSubmitter.blocking());

    protected AbstractWorkOrchestrator(String name) {
        this.name = name;
    }

    protected final String name() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start(ConfigurationPropertySource propertySource) {
        this.lifecycleLock.writeLock().lock();
        try {
            switch (this.state) {
                case RUNNING: {
                    return;
                }
                case PRE_STOPPING: {
                    throw new IllegalStateException("Cannot start an orchestrator while it's stopping");
                }
                case STOPPED: {
                    this.state = State.RUNNING;
                    this.doStart(propertySource);
                    return;
                }
            }
            return;
        }
        finally {
            this.lifecycleLock.writeLock().unlock();
        }
    }

    public final CompletableFuture<?> preStop() {
        this.lifecycleLock.writeLock().lock();
        try {
            switch (this.state) {
                case RUNNING: {
                    this.state = State.PRE_STOPPING;
                    CompletableFuture<?> completableFuture = this.completion();
                    return completableFuture;
                }
            }
            CompletableFuture<?> completableFuture = this.completion();
            return completableFuture;
        }
        finally {
            this.lifecycleLock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stop() {
        this.lifecycleLock.writeLock().lock();
        try {
            switch (this.state) {
                case RUNNING: 
                case PRE_STOPPING: {
                    this.state = State.STOPPED;
                    this.doStop();
                    return;
                }
            }
            return;
        }
        finally {
            this.lifecycleLock.writeLock().unlock();
        }
    }

    protected abstract void doStart(ConfigurationPropertySource var1);

    protected abstract void doSubmit(W var1, OperationSubmitter var2) throws InterruptedException;

    protected abstract CompletableFuture<?> completion();

    protected abstract void doStop();

    public final void submit(W work, OperationSubmitter operationSubmitter) {
        if (!this.lifecycleLock.readLock().tryLock()) {
            throw log.submittedWorkToStoppedOrchestrator(this.name);
        }
        try {
            if (!State.RUNNING.equals((Object)this.state)) {
                throw log.submittedWorkToStoppedOrchestrator(this.name);
            }
            this.doSubmit(work, operationSubmitter);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw log.threadInterruptedWhileSubmittingWork(this.name);
        }
        finally {
            this.lifecycleLock.readLock().unlock();
        }
    }

    private static enum State {
        RUNNING,
        PRE_STOPPING,
        STOPPED;

    }
}

