/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public interface BeanResolver {
    public <T> BeanHolder<T> resolve(Class<T> var1, BeanRetrieval var2);

    public <T> BeanHolder<T> resolve(Class<T> var1, String var2, BeanRetrieval var3);

    default public <T> BeanHolder<T> resolve(BeanReference<T> reference) {
        Contracts.assertNotNull(reference, (String)"reference");
        return reference.resolve(this);
    }

    default public <T> BeanHolder<List<T>> resolve(List<? extends BeanReference<? extends T>> references) {
        ArrayList<BeanHolder<? extends T>> beanHolders = new ArrayList<BeanHolder<? extends T>>();
        try {
            for (BeanReference<T> reference : references) {
                beanHolders.add(reference.resolve(this));
            }
            return BeanHolder.of(beanHolders);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(BeanHolder::close, beanHolders);
            throw e;
        }
    }

    public <T> List<BeanReference<T>> allConfiguredForRole(Class<T> var1);

    public <T> Map<String, BeanReference<T>> namedConfiguredForRole(Class<T> var1);
}

