/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.document.impl.LuceneIdReader;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;

public final class IdentifierValues
implements Values<String> {
    private final LuceneIdReader idReader;
    private BinaryDocValues currentLeafIdDocValues;

    public IdentifierValues(LuceneIdReader idReader) {
        this.idReader = idReader;
    }

    @Override
    public void context(LeafReaderContext context) throws IOException {
        this.currentLeafIdDocValues = this.idReader.idDocValues(context.reader());
    }

    @Override
    public String get(int doc) throws IOException {
        this.currentLeafIdDocValues.advance(doc);
        return this.currentLeafIdDocValues.binaryValue().utf8ToString();
    }
}

