/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class LuceneMatchIdPredicate
extends AbstractLuceneSearchPredicate {
    private final List<String> values;

    private LuceneMatchIdPredicate(Builder builder) {
        super(builder);
        this.values = builder.values;
        builder.values = null;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        List bytesRefs = this.values.stream().map(BytesRef::new).collect(Collectors.toList());
        return new TermInSetQuery(MetadataFields.idFieldName(), bytesRefs);
    }

    static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements MatchIdPredicateBuilder {
        private List<String> values = new ArrayList<String>();

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void value(Object value, ValueConvert valueConvert) {
            DslConverter converter = this.scope.identifier().dslConverter(valueConvert);
            ToDocumentValueConvertContext context = this.scope.toDocumentValueConvertContext();
            this.values.add((String)converter.unknownTypeToDocumentValue(value, context));
        }

        public SearchPredicate build() {
            return new LuceneMatchIdPredicate(this);
        }
    }
}

