/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneBooleanPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchAllPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchIdPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchNonePredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSimpleQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneUserProvidedLuceneQueryPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchNonePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;

public class LuceneSearchPredicateBuilderFactory
implements SearchPredicateBuilderFactory {
    private final LuceneSearchIndexScope<?> scope;

    public LuceneSearchPredicateBuilderFactory(LuceneSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public MatchAllPredicateBuilder matchAll() {
        return new LuceneMatchAllPredicate.Builder(this.scope);
    }

    public MatchNonePredicateBuilder matchNone() {
        return new LuceneMatchNonePredicate.Builder(this.scope);
    }

    public MatchIdPredicateBuilder id() {
        return new LuceneMatchIdPredicate.Builder(this.scope);
    }

    public BooleanPredicateBuilder bool() {
        return new LuceneBooleanPredicate.Builder(this.scope);
    }

    public SimpleQueryStringPredicateBuilder simpleQueryString() {
        return new LuceneSimpleQueryStringPredicate.Builder(this.scope);
    }

    public LuceneSearchPredicate fromLuceneQuery(Query query) {
        return new LuceneUserProvidedLuceneQueryPredicate(this.scope, query);
    }
}

