/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.hotrod;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;

public class RemoteCacheMutatorFactory<K, V>
implements MutatorFactory<K, V> {
    private final RemoteCache<K, V> cache;
    private final Function<V, Duration> maxIdle;

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache) {
        this(cache, null);
    }

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache, Function<V, Duration> maxIdle) {
        this.cache = cache;
        this.maxIdle = maxIdle;
    }

    public Mutator createMutator(K key, V value) {
        return new RemoteCacheEntryMutator<K, V>(this.cache, key, value, this.maxIdle);
    }
}

