/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.dmr.ModelNode;

public enum RequiredChildResourceDiscardPolicy implements DynamicDiscardPolicy
{
    REJECT_AND_WARN(DiscardPolicy.REJECT_AND_WARN),
    NEVER(DiscardPolicy.NEVER);

    private final DiscardPolicy policy;

    private RequiredChildResourceDiscardPolicy(DiscardPolicy policy) {
        this.policy = policy;
    }

    public DiscardPolicy checkResource(TransformationContext context, PathAddress address) {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        if (model.isDefined()) {
            for (String attribute : registration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
                if (!model.hasDefined(attribute)) continue;
                return this.policy;
            }
        }
        for (PathElement path : registration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            if (!(path.isWildcard() ? resource.hasChildren(path.getKey()) : resource.hasChild(path))) continue;
            return this.policy;
        }
        return DiscardPolicy.SILENT;
    }
}

