/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.MergeableMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class Messages {
    private Messages() {
    }

    public static <T> Message<T> merge(List<Message<?>> list, Function<List<?>, T> combinator) {
        T payload;
        if (list.isEmpty()) {
            return Message.of(combinator.apply(Collections.emptyList()));
        }
        try {
            payload = combinator.apply(list.stream().map(Message::getPayload).collect(Collectors.toList()));
        }
        catch (Exception e2) {
            list.forEach(m -> m.nack(e2));
            throw e2;
        }
        Supplier<CompletionStage<Void>> ack = () -> {
            ArrayList<CompletableFuture<Void>> acks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                acks.add(message.ack().toCompletableFuture());
            }
            return CompletableFuture.allOf(acks.toArray(new CompletableFuture[0]));
        };
        Function<Throwable, CompletionStage<Void>> nack = e -> {
            ArrayList<CompletableFuture<Void>> nacks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                nacks.add(message.nack((Throwable)e).toCompletableFuture());
            }
            return CompletableFuture.allOf(nacks.toArray(new CompletableFuture[0]));
        };
        Metadata metadata = list.get(0).getMetadata();
        for (int i = 1; i < list.size(); ++i) {
            Metadata other = list.get(i).getMetadata();
            metadata = Messages.merge(metadata, other);
        }
        return Message.of(payload).withAck(ack).withNack(nack).withMetadata(metadata);
    }

    public static <T> Message<List<T>> merge(List<Message<T>> list) {
        if (list.isEmpty()) {
            return Message.of(Collections.emptyList());
        }
        List payload = list.stream().map(Message::getPayload).collect(Collectors.toList());
        Supplier<CompletionStage<Void>> ack = () -> {
            ArrayList<CompletableFuture<Void>> acks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                acks.add(message.ack().toCompletableFuture());
            }
            return CompletableFuture.allOf(acks.toArray(new CompletableFuture[0]));
        };
        Function<Throwable, CompletionStage<Void>> nack = e -> {
            ArrayList<CompletableFuture<Void>> nacks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                nacks.add(message.nack((Throwable)e).toCompletableFuture());
            }
            return CompletableFuture.allOf(nacks.toArray(new CompletableFuture[0]));
        };
        Metadata metadata = list.get(0).getMetadata();
        for (int i = 1; i < list.size(); ++i) {
            Metadata other = list.get(i).getMetadata();
            metadata = Messages.merge(metadata, other);
        }
        return Message.of(payload).withAck(ack).withNack(nack).withMetadata(metadata);
    }

    private static Metadata merge(Metadata first, Metadata second) {
        Metadata result = first;
        for (Object meta : second) {
            Class<?> clazz = meta.getClass();
            Optional<?> value = result.get(clazz);
            if (value.isEmpty()) {
                result = result.with(meta);
                continue;
            }
            if (!MergeableMetadata.class.isAssignableFrom(clazz)) continue;
            MergeableMetadata current = (MergeableMetadata)value.get();
            Object merged = current.merge(meta);
            if (merged != null) {
                result = result.with(merged);
                continue;
            }
            result = result.without(clazz);
        }
        return result;
    }
}

