/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.mechanism;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.mechanism.MechanismLogging;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jose4j.lang.UnresolvableKeyException;

@ApplicationScoped
public class JWTHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private JWTParser jwtParser;
    @Inject
    private PrincipalProducer producer;
    @Inject
    private Instance<IdentityStore> identityStores;

    public JWTHttpAuthenticationMechanism() {
    }

    public JWTHttpAuthenticationMechanism(JWTAuthContextInfo authContextInfo, JWTParser jwtParser, PrincipalProducer producer) {
        this.authContextInfo = authContextInfo;
        this.jwtParser = jwtParser;
        this.producer = producer;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        BearerTokenExtractor extractor = new BearerTokenExtractor(request, this.authContextInfo);
        String bearerToken = extractor.getBearerToken();
        if (bearerToken != null) {
            try {
                JsonWebToken jwtPrincipal = this.jwtParser.parse(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                Set groups = jwtPrincipal.getGroups();
                String name = jwtPrincipal.getName();
                for (IdentityStore identityStore : this.identityStores) {
                    if (!identityStore.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) continue;
                    CredentialValidationResult credentialValidationResult = new CredentialValidationResult(name, groups);
                    Set callerGroups = identityStore.getCallerGroups(credentialValidationResult);
                    groups.addAll(callerGroups);
                }
                MechanismLogging.log.success();
                return httpMessageContext.notifyContainerAboutLogin((Principal)jwtPrincipal, groups);
            }
            catch (ParseException e) {
                if (e.getCause() instanceof UnresolvableKeyException) {
                    MechanismLogging.log.noUsableKey();
                    return this.reportInternalError(httpMessageContext);
                }
                MechanismLogging.log.unableToValidateBearerToken(e);
                return httpMessageContext.responseUnauthorized();
            }
            catch (Exception e) {
                MechanismLogging.log.unableToValidateBearerToken(e);
                return this.reportInternalError(httpMessageContext);
            }
        }
        MechanismLogging.log.noUsableBearerTokenFound();
        return httpMessageContext.isProtected() ? httpMessageContext.responseUnauthorized() : httpMessageContext.doNothing();
    }

    private AuthenticationStatus reportInternalError(HttpMessageContext httpMessageContext) {
        try {
            httpMessageContext.getResponse().sendError(500);
        }
        catch (IOException ioException) {
            throw new IllegalStateException(ioException);
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final HttpServletRequest request;

        BearerTokenExtractor(HttpServletRequest request, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.request = request;
        }

        protected String getHeaderValue(String headerName) {
            return this.request.getHeader(headerName);
        }

        protected String getCookieValue(String cookieName) {
            Cookie[] cookies = this.request.getCookies();
            Cookie tokenCookie = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    tokenCookie = cookie;
                    break;
                }
            }
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

