/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.wildfly.clustering.marshalling.spi.ByteBufferInputStream;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;
import org.wildfly.clustering.marshalling.spi.Marshaller;

public interface ByteBufferMarshaller
extends Marshaller<Object, ByteBuffer> {
    public static final Logger LOGGER = Logger.getLogger(ByteBufferMarshaller.class);

    public Object readFrom(InputStream var1) throws IOException;

    public void writeTo(OutputStream var1, Object var2) throws IOException;

    @Override
    default public Object read(ByteBuffer buffer) throws IOException {
        try (ByteBufferInputStream input = new ByteBufferInputStream(buffer);){
            Object object = this.readFrom(input);
            return object;
        }
    }

    @Override
    default public ByteBuffer write(Object object) throws IOException {
        OptionalInt size = this.size(object);
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(size);){
            this.writeTo(output, object);
            ByteBuffer buffer = output.getBuffer();
            if (size.isPresent()) {
                int actualSize;
                int predictedSize = size.getAsInt();
                if (predictedSize < (actualSize = buffer.limit() - buffer.arrayOffset())) {
                    LOGGER.debugf("Buffer size prediction too small for %s (%s), predicted = %d, actual = %d", new Object[]{object, object != null ? object.getClass().getCanonicalName() : null, predictedSize, actualSize});
                }
            } else {
                LOGGER.tracef("Buffer size prediction missing for %s (%s)", object, object != null ? object.getClass().getCanonicalName() : null);
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    default public OptionalInt size(Object object) {
        return OptionalInt.empty();
    }
}

