/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;

public class LongRangeFacetCounts
extends RangeFacetCounts {
    public LongRangeFacetCounts(String field, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, null, hits, ranges);
    }

    public LongRangeFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits, LongRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public LongRangeFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, LongRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        if (valueSource != null) {
            this.count(valueSource, hits.getMatchingDocs());
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    private void count(LongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRange[] ranges = this.getLongRanges();
        LongRangeCounter counter = LongRangeCounter.create(ranges, this.counts);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            LongValues fv = valueSource.getValues(hits.context, null);
            this.totCount += hits.totalHits;
            DocIdSetIterator it = this.createIterator(hits);
            if (it == null) continue;
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    counter.addSingleValued(fv.longValue());
                } else {
                    ++missingCount;
                }
                doc = it.nextDoc();
            }
        }
        this.totCount -= (missingCount += counter.finish());
    }

    @Override
    protected LongRange[] getLongRanges() {
        return (LongRange[])this.ranges;
    }
}

