/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AcknowledgementCoordinator {
    private final Message<?> input;
    private volatile boolean done;
    private final List<Tracker> tracked = new ArrayList<Tracker>();

    public AcknowledgementCoordinator(Message<?> input) {
        this.input = input;
    }

    public synchronized Message<?> track(Message<?> msg) {
        Tracker tracker = new Tracker();
        this.tracked.add(tracker);
        return msg.withAck(() -> {
            this.onAck(tracker);
            return CompletableFuture.completedFuture(null);
        }).withNack(reason -> {
            this.onNack((Throwable)reason, tracker);
            return CompletableFuture.completedFuture(null);
        });
    }

    private synchronized void onAck(Tracker id) {
        if (this.done) {
            return;
        }
        if (this.tracked.remove(id) && this.tracked.isEmpty() && !this.done) {
            this.done = true;
            this.input.ack();
        }
    }

    private synchronized void onNack(Throwable reason, Tracker id) {
        if (this.done) {
            return;
        }
        if (this.tracked.remove(id)) {
            this.done = true;
            this.tracked.clear();
            this.input.nack(reason);
        }
    }

    static class Tracker {
        Tracker() {
        }
    }
}

