/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRASession;

public class ActiveMQRAMessageProducer
implements MessageProducer {
    protected MessageProducer producer;
    protected ActiveMQRASession session;

    public ActiveMQRAMessageProducer(MessageProducer producer, ActiveMQRASession session) {
        this.producer = producer;
        this.session = session;
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("new ActiveMQMessageProducer " + this + " producer=" + producer + " session=" + session);
        }
    }

    public void close() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("close " + this);
        }
        try {
            this.closeProducer();
        }
        finally {
            this.session.removeProducer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send(destination, message, deliveryMode, priority, timeToLive);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " destination=" + destination + " message=" + message);
            }
            this.checkState();
            this.producer.send(destination, message);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive);
            }
            this.checkState();
            this.producer.send(message, deliveryMode, priority, timeToLive);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Message message) throws JMSException {
        this.session.lock();
        try {
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("send " + this + " message=" + message);
            }
            this.checkState();
            this.producer.send(message);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("sent " + this + " result=" + message);
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getRoutingType()");
        }
        return this.producer.getDeliveryMode();
    }

    public Destination getDestination() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getDestination()");
        }
        return this.producer.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getDisableMessageID()");
        }
        return this.producer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getDisableMessageTimestamp()");
        }
        return this.producer.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getPriority()");
        }
        return this.producer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getTimeToLive()");
        }
        return this.producer.getTimeToLive();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setRoutingType(" + deliveryMode + ")");
        }
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setDisableMessageID(" + value + ")");
        }
        this.producer.setDisableMessageID(value);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setDisableMessageTimestamp(" + value + ")");
        }
        this.producer.setDisableMessageTimestamp(value);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setPriority(" + defaultPriority + ")");
        }
        this.producer.setPriority(defaultPriority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setTimeToLive(" + timeToLive + ")");
        }
        this.producer.setTimeToLive(timeToLive);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setDeliveryDelay(" + deliveryDelay + ")");
        }
        this.producer.setDeliveryDelay(deliveryDelay);
    }

    public long getDeliveryDelay() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getDeliveryDelay()");
        }
        return this.producer.getDeliveryDelay();
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("send(" + message + ", " + completionListener + ")");
        }
        this.producer.send(message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("send(" + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ", " + completionListener + ")");
        }
        this.producer.send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("send(" + destination + ", " + message + ", " + completionListener + ")");
        }
        this.producer.send(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("send(" + destination + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ", " + completionListener + ")");
        }
        this.producer.send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    void checkState() throws JMSException {
        this.session.checkState();
    }

    void closeProducer() throws JMSException {
        this.producer.close();
    }
}

