/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.annotated.slim;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AnnotatedTypeMarshaller<X, T extends SlimAnnotatedType<X>>
implements ProtoStreamMarshaller<T> {
    private static final int IDENTIFIER_INDEX = 1;
    private final Class<T> targetClass;

    public AnnotatedTypeMarshaller(Class<T> targetClass) {
        this.targetClass = targetClass;
    }

    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }

    public T readFrom(ProtoStreamReader reader) throws IOException {
        AnnotatedTypeIdentifier identifier = null;
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    identifier = (AnnotatedTypeIdentifier)reader.readObject(AnnotatedTypeIdentifier.class);
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        BeanManagerImpl manager = Container.instance(identifier).getBeanManager(identifier.getBdaId());
        return this.getAnnotatedType(identifier, manager);
    }

    protected T getAnnotatedType(AnnotatedTypeIdentifier identifier, BeanManagerImpl manager) {
        return (T)ClassTransformer.instance((BeanManagerImpl)manager).getSlimAnnotatedTypeById(identifier);
    }

    public void writeTo(ProtoStreamWriter writer, T type) throws IOException {
        AnnotatedTypeIdentifier identifier = (AnnotatedTypeIdentifier)type.getIdentifier();
        if (identifier != null) {
            writer.writeObject(1, (Object)identifier);
        }
    }
}

