/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.vfs.VirtualFile;
import org.jboss.ws.common.deployment.SOAPAddressWSDLParser;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

public final class WSIntegrationProcessorJAXWS_JMS
implements DeploymentUnitProcessor {
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String PORT_NAME = "portName";
    private static final String SERVICE_NAME = "serviceName";
    private static final String TARGET_NAMESPACE = "targetNamespace";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        List<AnnotationInstance> webServiceAnnotations = ASHelper.getAnnotations(unit, DotNames.WEB_SERVICE_ANNOTATION);
        HashMap<String, LinkedList<AnnotationInstance>> map = new HashMap<String, LinkedList<AnnotationInstance>>();
        for (AnnotationInstance webServiceAnnotation : webServiceAnnotations) {
            Object wsdlLocation = webServiceAnnotation.value(WSDL_LOCATION);
            AnnotationValue port = webServiceAnnotation.value(PORT_NAME);
            AnnotationValue service = webServiceAnnotation.value(SERVICE_NAME);
            if (wsdlLocation == null || port == null || service == null) continue;
            String key = wsdlLocation.asString();
            LinkedList<AnnotationInstance> annotations = (LinkedList<AnnotationInstance>)map.get(key);
            if (annotations == null) {
                annotations = new LinkedList<AnnotationInstance>();
                map.put(key, annotations);
            }
            annotations.add(webServiceAnnotation);
        }
        LinkedList<JMSEndpointMetaData> list = new LinkedList<JMSEndpointMetaData>();
        if (!map.isEmpty()) {
            for (Object wsdlLocation : map.keySet()) {
                try {
                    ResourceRoot resourceRoot = WSIntegrationProcessorJAXWS_JMS.getWsdlResourceRoot(unit, (String)wsdlLocation);
                    if (resourceRoot == null) continue;
                    VirtualFile wsdlLocationFile = resourceRoot.getRoot().getChild((String)wsdlLocation);
                    URL url = wsdlLocationFile.toURL();
                    SOAPAddressWSDLParser parser = new SOAPAddressWSDLParser(url);
                    for (AnnotationInstance ai : (List)map.get(wsdlLocation)) {
                        QName portName;
                        String port = ai.value(PORT_NAME).asString();
                        String service = ai.value(SERVICE_NAME).asString();
                        AnnotationValue targetNS = ai.value(TARGET_NAMESPACE);
                        String tns = targetNS != null ? targetNS.asString() : null;
                        QName serviceName = new QName(tns, service);
                        String soapAddress = parser.filterSoapAddress(serviceName, portName = new QName(tns, port), "http://www.w3.org/2010/soapjms/");
                        if (soapAddress == null) continue;
                        ClassInfo webServiceClassInfo = (ClassInfo)ai.target();
                        String beanClassName = webServiceClassInfo.name().toString();
                        list.add(new JMSEndpointMetaData(beanClassName, port, beanClassName, (String)wsdlLocation, soapAddress));
                    }
                }
                catch (Exception ignore) {
                    WSLogger.ROOT_LOGGER.cannotReadWsdl((String)wsdlLocation);
                }
            }
        }
        unit.putAttachment(WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY, (Object)new JMSEndpointsMetaData(list));
    }

    private static ResourceRoot getWsdlResourceRoot(DeploymentUnit unit, String wsdlPath) {
        AttachmentList resourceRoots = new AttachmentList(ResourceRoot.class);
        ResourceRoot root = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        resourceRoots.add((Object)root);
        AttachmentList otherResourceRoots = (AttachmentList)unit.getAttachment(Attachments.RESOURCE_ROOTS);
        if (otherResourceRoots != null) {
            resourceRoots.addAll((Collection)otherResourceRoots);
        }
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile file = resourceRoot.getRoot().getChild(wsdlPath);
            if (!file.exists()) continue;
            return resourceRoot;
        }
        return null;
    }
}

