/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.ObjectName;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

public class ServiceContainerEndpointRegistry
implements EndpointRegistry {
    private static final Map<ServiceName, Endpoint> endpoints = new ConcurrentHashMap<ServiceName, Endpoint>();

    public Set<ObjectName> getEndpoints() {
        CopyOnWriteArraySet<ObjectName> retVal = new CopyOnWriteArraySet<ObjectName>();
        for (ServiceName sname : endpoints.keySet()) {
            String contextPath = sname.getParent().getSimpleName().substring(8);
            String endpointName = sname.getSimpleName();
            StringBuilder name = new StringBuilder("jboss.ws:");
            name.append("context=").append(contextPath).append(",");
            name.append("endpoint=").append(endpointName);
            retVal.add(ObjectNameFactory.create((String)name.toString()));
        }
        return retVal;
    }

    public Endpoint getEndpoint(ObjectName epName) {
        String context = epName.getKeyProperty("context");
        String name = epName.getKeyProperty("endpoint");
        ServiceName endpointName = WSServices.ENDPOINT_SERVICE.append(new String[]{"context=" + context}).append(new String[]{name});
        return ServiceContainerEndpointRegistry.getEndpoint(endpointName);
    }

    public Endpoint resolve(EndpointResolver resolver) {
        return resolver.query(new CopyOnWriteArraySet<Endpoint>(endpoints.values()).iterator());
    }

    public boolean isRegistered(ObjectName epName) {
        return this.getEndpoint(epName) != null;
    }

    public static void register(ServiceName endpointName, Endpoint endpoint) {
        endpoints.put(endpointName, endpoint);
    }

    public static void unregister(ServiceName endpointName, Endpoint endpoint) {
        endpoints.remove(endpointName, endpoint);
    }

    public static Endpoint getEndpoint(ServiceName endpointName) {
        return endpoints.get(endpointName);
    }
}

