/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class PooledConnectionFactoryStatisticsService
implements Service<ManagementResourceRegistration> {
    private static final PathElement POOL_STATISTICS = PathElement.pathElement((String)"statistics", (String)"pool");
    private final ManagementResourceRegistration registration;
    private final boolean statsEnabled;
    protected final InjectedValue<ResourceAdapterDeployment> injectedRADeployment = new InjectedValue();

    public PooledConnectionFactoryStatisticsService(ManagementResourceRegistration registration, boolean statsEnabled) {
        this.registration = registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        MessagingLogger.ROOT_LOGGER.debugf("start PooledConnectionFactoryStatisticsService", new Object[0]);
        PathElement pathElement = POOL_STATISTICS;
        synchronized (pathElement) {
            ResourceAdapterDeployment raDeployment = (ResourceAdapterDeployment)this.injectedRADeployment.getValue();
            CommonDeployment deployment = raDeployment.getDeployment();
            PoolStatistics poolStats = deployment.getConnectionManagers()[0].getPool().getStatistics();
            poolStats.setEnabled(this.statsEnabled);
            int poolStatsSize = poolStats.getNames().size();
            if (poolStatsSize > 0 && this.registration != null && this.registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{POOL_STATISTICS})) == null) {
                ManagementResourceRegistration managementResourceRegistration = this.registration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(POOL_STATISTICS, DataSourcesSubsystemProviders.RESOURCE_NAME, (StatisticsPlugin)poolStats));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        PathElement pathElement = POOL_STATISTICS;
        synchronized (pathElement) {
            if (this.registration != null) {
                this.registration.unregisterSubModel(POOL_STATISTICS);
            }
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.registration;
    }

    public Injector<ResourceAdapterDeployment> getRADeploymentInjector() {
        return this.injectedRADeployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStatisticsResources(Resource resource) {
        PathElement pathElement = POOL_STATISTICS;
        synchronized (pathElement) {
            if (!resource.hasChild(POOL_STATISTICS)) {
                resource.registerChild(POOL_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(POOL_STATISTICS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStatisticsResources(Resource resource) {
        PathElement pathElement = POOL_STATISTICS;
        synchronized (pathElement) {
            if (resource.hasChild(POOL_STATISTICS)) {
                resource.removeChild(POOL_STATISTICS);
            }
        }
    }
}

