/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class ReflectionHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;

    private ReflectionHelper() {
    }

    public static Class<?> getPrimitiveWrapperType(Class<?> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            throw new IllegalArgumentException("Argument primitiveType must be a Class representing a primitive Java type");
        }
        return PRIMITIVES_TO_WRAPPERS.get(primitiveType);
    }

    static {
        HashMap<Class<Object>, Class<Void>> map = new HashMap<Class<Object>, Class<Void>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
        PRIMITIVES_TO_WRAPPERS = CollectionHelper.toImmutableMap(map);
    }
}

