/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmAuthorizationEvent;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.AggregateAttributes;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm[] authorizationRealms;
    private final Function<Principal, Principal> principalTransformer;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        Assert.checkNotNullParam((String)"authorizationRealm", (Object)authorizationRealm);
        this.authorizationRealms = new SecurityRealm[]{authorizationRealm};
        this.principalTransformer = null;
    }

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm ... authorizationRealms) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        this.authorizationRealms = (SecurityRealm[])Assert.checkNotNullParam((String)"authorizationRealms", (Object)authorizationRealms);
        this.principalTransformer = null;
    }

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, Function<Principal, Principal> principalTransformer, SecurityRealm ... authorizationRealms) {
        this.authenticationRealm = (SecurityRealm)Assert.checkNotNullParam((String)"authenticationRealm", (Object)authenticationRealm);
        this.authorizationRealms = (SecurityRealm[])Assert.checkNotNullParam((String)"authorizationRealms", (Object)authorizationRealms);
        this.principalTransformer = principalTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(evidence);
        if (authenticationIdentity.exists()) {
            ElytronMessages.log.tracef("Authentication identity for principal [%s] found.", evidence.getDecodedPrincipal());
        }
        RealmIdentity[] authorizationIdentities = new RealmIdentity[this.authorizationRealms.length];
        try {
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                SecurityRealm authorizationRealm = this.authorizationRealms[i];
                RealmIdentity realmIdentity = authorizationIdentities[i] = authorizationRealm == this.authenticationRealm ? authenticationIdentity : this.getAuthorizationIdentity(authorizationRealm, evidence, this.principalTransformer, authenticationIdentity);
                if (!authorizationIdentities[i].exists()) continue;
                ElytronMessages.log.tracef("Authorization identity for principal [%s] found.", evidence.getDecodedPrincipal());
            }
            Identity identity = new Identity(authenticationIdentity, authorizationIdentities);
            ok = true;
            Identity identity2 = identity;
            return identity2;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
                for (RealmIdentity current : authorizationIdentities) {
                    if (current == null) continue;
                    current.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.getRealmIdentity(principal);
        if (authenticationIdentity.exists()) {
            ElytronMessages.log.tracef("Authentication identity for principal [%s] found.", principal);
        }
        Principal authorizationPrincipal = principal;
        if (this.principalTransformer != null && (authorizationPrincipal = this.principalTransformer.apply(authorizationPrincipal)) == null) {
            throw ElytronMessages.log.transformedPrincipalCannotBeNull();
        }
        RealmIdentity[] authorizationIdentities = new RealmIdentity[this.authorizationRealms.length];
        try {
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                SecurityRealm authorizationRealm = this.authorizationRealms[i];
                RealmIdentity realmIdentity = authorizationIdentities[i] = authorizationRealm == this.authenticationRealm && this.principalTransformer == null ? authenticationIdentity : authorizationRealm.getRealmIdentity(authorizationPrincipal);
                if (!authorizationIdentities[i].exists()) continue;
                ElytronMessages.log.tracef("Authorization identity for principal [%s] found.", principal);
            }
            Identity identity = new Identity(authenticationIdentity, authorizationIdentities);
            ok = true;
            Identity identity2 = identity;
            return identity2;
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
                for (RealmIdentity current : authorizationIdentities) {
                    if (current == null) continue;
                    current.dispose();
                }
            }
        }
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    private RealmIdentity getAuthorizationIdentity(SecurityRealm authorizationRealm, Evidence evidence, Function<Principal, Principal> principalTransformer, RealmIdentity authenticationIdentity) throws RealmUnavailableException {
        if (principalTransformer == null) {
            if (evidence.getPrincipal() == null) {
                return authorizationRealm.getRealmIdentity(authenticationIdentity.getRealmIdentityPrincipal());
            }
            return authorizationRealm.getRealmIdentity(evidence);
        }
        if (evidence.getPrincipal() == null) {
            Principal authorizationPrincipal = authenticationIdentity.getRealmIdentityPrincipal();
            if ((authorizationPrincipal = principalTransformer.apply(authorizationPrincipal)) == null) {
                throw ElytronMessages.log.transformedPrincipalCannotBeNull();
            }
            return authorizationRealm.getRealmIdentity(authorizationPrincipal);
        }
        return authorizationRealm.getRealmIdentity(evidence, principalTransformer);
    }

    public void handleRealmEvent(RealmEvent event) {
        if (event instanceof RealmAuthenticationEvent) {
            this.authenticationRealm.handleRealmEvent(event);
        } else if (event instanceof RealmAuthorizationEvent) {
            for (SecurityRealm current : this.authorizationRealms) {
                SecurityRealm.safeHandleRealmEvent((SecurityRealm)current, (RealmEvent)event);
            }
        } else {
            SecurityRealm.safeHandleRealmEvent((SecurityRealm)this.authenticationRealm, (RealmEvent)event);
            for (SecurityRealm current : this.authorizationRealms) {
                SecurityRealm.safeHandleRealmEvent((SecurityRealm)current, (RealmEvent)event);
            }
        }
    }

    static final class Identity
    implements RealmIdentity {
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity[] authorizationIdentities;

        Identity(RealmIdentity authenticationIdentity, RealmIdentity[] authorizationIdentities) {
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentities = authorizationIdentities;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.authenticationIdentity.getRealmIdentityPrincipal();
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType, algorithmName, parameterSpec);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return (C)this.authenticationIdentity.getCredential(credentialType);
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyEvidence(evidence);
        }

        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (this.authorizationIdentities.length == 1) {
                return this.authorizationIdentities[0].getAuthorizationIdentity();
            }
            AuthorizationIdentity[] authorizationIdentities = new AuthorizationIdentity[this.authorizationIdentities.length];
            for (int i = 0; i < authorizationIdentities.length; ++i) {
                authorizationIdentities[i] = this.authorizationIdentities[i].getAuthorizationIdentity();
            }
            return AuthorizationIdentity.basicIdentity(() -> this.combineAttributes(authorizationIdentities), (String)"Aggregated");
        }

        private Attributes combineAttributes(AuthorizationIdentity[] authorizationIdentities) {
            Attributes[] attributes = new Attributes[authorizationIdentities.length];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = authorizationIdentities[i].getAttributes();
            }
            return AggregateAttributes.aggregateOf((Attributes[])attributes);
        }

        public void dispose() {
            this.authenticationIdentity.dispose();
            for (RealmIdentity current : this.authorizationIdentities) {
                current.dispose();
            }
        }
    }
}

