/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.BitSet;
import java.util.regex.Pattern;
import org.infinispan.objectfilter.impl.predicateindex.Condition;

public final class LikeCondition
implements Condition<String> {
    private final Type type;
    private final String likePattern;
    private final Pattern regexPattern;
    private final String value;
    private final int length;

    public LikeCondition(String likePattern) {
        this(likePattern, '\\');
    }

    public LikeCondition(String likePattern, char escapeCharacter) {
        this.likePattern = likePattern;
        StringBuilder sb = new StringBuilder(likePattern.length());
        BitSet multi = new BitSet(likePattern.length());
        int multiCount = 0;
        BitSet single = new BitSet(likePattern.length());
        int singleCount = 0;
        boolean isEscaped = false;
        for (int i = 0; i < likePattern.length(); ++i) {
            char c = likePattern.charAt(i);
            if (!isEscaped && c == escapeCharacter) {
                isEscaped = true;
                continue;
            }
            if (isEscaped) {
                isEscaped = false;
            } else if (c == '%') {
                multi.set(sb.length());
                ++multiCount;
            } else if (c == '_') {
                single.set(sb.length());
                ++singleCount;
            }
            sb.append(c);
        }
        if (multiCount == 0 && singleCount == 0) {
            this.type = Type.Equals;
            this.value = sb.toString();
            this.regexPattern = null;
            this.length = -1;
        } else {
            if (multi.get(0)) {
                if (singleCount == 0) {
                    if (multiCount == 1) {
                        this.type = Type.EndsWith;
                        this.value = sb.substring(1);
                        this.length = -1;
                        this.regexPattern = null;
                        return;
                    }
                    if (multiCount == 2 && multi.get(sb.length() - 1)) {
                        this.type = Type.Contains;
                        this.value = sb.substring(1, sb.length() - 1);
                        this.length = -1;
                        this.regexPattern = null;
                        return;
                    }
                }
            } else if (single.get(0)) {
                if (multiCount == 0 && singleCount == 1) {
                    this.type = Type.EndsWith;
                    this.value = sb.substring(1);
                    this.length = sb.length();
                    this.regexPattern = null;
                    return;
                }
            } else if (multi.get(sb.length() - 1)) {
                if (multiCount == 1 && singleCount == 0) {
                    this.type = Type.StartsWith;
                    this.value = sb.substring(0, sb.length() - 1);
                    this.length = -1;
                    this.regexPattern = null;
                    return;
                }
            } else if (single.get(sb.length() - 1) && singleCount == 1 && multiCount == 0) {
                this.type = Type.StartsWith;
                this.value = sb.substring(0, sb.length() - 1);
                this.length = sb.length();
                this.regexPattern = null;
                return;
            }
            StringBuilder regexpPattern = new StringBuilder(sb.length() + 2);
            regexpPattern.append('^');
            for (int i = 0; i < sb.length(); ++i) {
                if (multi.get(i)) {
                    regexpPattern.append(".*");
                    continue;
                }
                if (single.get(i)) {
                    regexpPattern.append('.');
                    continue;
                }
                char c = sb.charAt(i);
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        regexpPattern.append('\\');
                    }
                }
                regexpPattern.append(c);
            }
            regexpPattern.append('$');
            this.type = Type.Regexp;
            this.regexPattern = Pattern.compile(regexpPattern.toString());
            this.value = null;
            this.length = -1;
        }
    }

    @Override
    public boolean match(String attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        switch (this.type) {
            case Equals: {
                return attributeValue.equals(this.value);
            }
            case StartsWith: {
                return (this.length == -1 || this.length == attributeValue.length()) && attributeValue.startsWith(this.value);
            }
            case EndsWith: {
                return (this.length == -1 || this.length == attributeValue.length()) && attributeValue.endsWith(this.value);
            }
            case Contains: {
                return attributeValue.contains(this.value);
            }
            case Regexp: {
                return this.regexPattern.matcher(attributeValue).matches();
            }
        }
        throw new IllegalStateException("Unexpected type " + this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LikeCondition other = (LikeCondition)obj;
        return this.likePattern.equals(other.likePattern);
    }

    public int hashCode() {
        return this.likePattern.hashCode();
    }

    public String toString() {
        return "LikeCondition(" + this.likePattern + ")";
    }

    private static enum Type {
        Regexp,
        Contains,
        StartsWith,
        EndsWith,
        Equals;

    }
}

