/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.routing.infinispan;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheConfiguration;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.WebDeploymentConfiguration;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocator;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;
import org.wildfly.extension.clustering.web.routing.RouteLocatorServiceNameProvider;

public class PrimaryOwnerRouteLocatorServiceConfigurator
extends RouteLocatorServiceNameProvider
implements CapabilityServiceConfigurator,
PrimaryOwnerRouteLocatorConfiguration,
Supplier<RouteLocator> {
    private final InfinispanCacheConfiguration configuration;
    private final WebDeploymentConfiguration deploymentConfiguration;
    private volatile SupplierDependency<Registry<String, Void>> registry;
    private volatile SupplierDependency<Cache<GroupedKey<String>, ?>> cache;
    private volatile SupplierDependency<NodeFactory<Address>> factory;

    public PrimaryOwnerRouteLocatorServiceConfigurator(InfinispanCacheConfiguration configuration, WebDeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
        this.configuration = configuration;
        this.deploymentConfiguration = deploymentConfiguration;
    }

    @Override
    public RouteLocator get() {
        return new PrimaryOwnerRouteLocator((PrimaryOwnerRouteLocatorConfiguration)this);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = new AsyncServiceConfigurator(name).build(target);
        Consumer locator = new CompositeDependency(new Dependency[]{this.registry, this.cache, this.factory}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(locator, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.registry = new ServiceSupplierDependency(ClusteringCacheRequirement.REGISTRY.getServiceName(support, this.configuration.getContainerName(), this.deploymentConfiguration.getServerName()));
        this.factory = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.configuration.getContainerName(), this.deploymentConfiguration.getServerName()));
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.configuration.getContainerName(), this.deploymentConfiguration.getDeploymentName()));
        return this;
    }

    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.get();
    }

    public Cache<GroupedKey<String>, ?> getCache() {
        return (Cache)this.cache.get();
    }

    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.get();
    }
}

