/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.DiscoverySubsystemDefinition;
import org.wildfly.extension.discovery.DiscoverySubsystemModel;
import org.wildfly.extension.discovery.DiscoverySubsystemSchema;

public final class DiscoveryExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "discovery";
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("discovery", DiscoveryExtension.class);
    static final RuntimeCapability<?> DISCOVERY_PROVIDER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.discovery.provider", (boolean)true).setServiceType(DiscoveryProvider.class).setAllowMultipleRegistrations(true).build();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, DiscoverySubsystemModel.CURRENT.getVersion());
        subsystemRegistration.setHostCapable();
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter((PersistentSubsystemSchema)DiscoverySubsystemSchema.CURRENT));
        ManagementResourceRegistration resourceRegistration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new DiscoverySubsystemDefinition());
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (DiscoverySubsystemSchema schema : EnumSet.allOf(DiscoverySubsystemSchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)schema);
        }
    }
}

