/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.spi;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import jakarta.transaction.Transaction;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.reactivestreams.Publisher;

@Experimental
public interface NonBlockingStore<K, V> {
    public static final CompletableFuture<Long> SIZE_UNAVAILABLE_FUTURE = CompletableFuture.completedFuture(-1L);

    public CompletionStage<Void> start(InitializationContext var1);

    public CompletionStage<Void> stop();

    default public CompletionStage<Void> destroy() {
        return this.stop();
    }

    default public Set<Characteristic> characteristics() {
        return EnumSet.noneOf(Characteristic.class);
    }

    default public CompletionStage<Boolean> isAvailable() {
        return CompletableFutures.completedTrue();
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int var1, Object var2);

    default public CompletionStage<Boolean> containsKey(int segment, Object key) {
        return this.load(segment, key).thenApply(Objects::nonNull);
    }

    public CompletionStage<Void> write(int var1, MarshallableEntry<? extends K, ? extends V> var2);

    public CompletionStage<Boolean> delete(int var1, Object var2);

    default public CompletionStage<Void> addSegments(IntSet segments) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.SEGMENTABLE + ", but it does not implement addSegments");
    }

    default public CompletionStage<Void> removeSegments(IntSet segments) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.SEGMENTABLE + ", but it does not implement removeSegments");
    }

    public CompletionStage<Void> clear();

    default public CompletionStage<Void> batch(int publisherCount, Publisher<SegmentedPublisher<Object>> removePublisher, Publisher<SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        Flowable entriesWritten = Flowable.fromPublisher(writePublisher).concatMapEager(sp -> Flowable.fromPublisher((Publisher)sp).concatMapCompletable(me -> Completable.fromCompletionStage(this.write(sp.getSegment(), (MarshallableEntry<? extends K, ? extends V>)me))).toFlowable(), publisherCount, publisherCount);
        Flowable removedKeys = Flowable.fromPublisher(removePublisher).concatMapEager(sp -> Flowable.fromPublisher((Publisher)sp).concatMapCompletable(key -> Completable.fromCompletionStage(this.delete(sp.getSegment(), key))).toFlowable(), publisherCount, publisherCount);
        return Flowable.concatArrayEager((Publisher[])new Publisher[]{entriesWritten, removedKeys}).lastStage(null);
    }

    default public CompletionStage<Long> size(IntSet segments) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.BULK_READ + ", but it does not implement size");
    }

    default public CompletionStage<Long> approximateSize(IntSet segments) {
        return SIZE_UNAVAILABLE_FUTURE;
    }

    default public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.BULK_READ + ", but it does not implement entryPublisher");
    }

    default public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return Flowable.fromPublisher(this.publishEntries(segments, filter, false)).map(MarshallableEntry::getKey);
    }

    default public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.EXPIRATION + ", but it does not implement purgeExpired");
    }

    default public CompletionStage<Void> prepareWithModifications(Transaction transaction, int publisherCount, Publisher<SegmentedPublisher<Object>> removePublisher, Publisher<SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.TRANSACTIONAL + ", but it does not implement prepareWithModifications");
    }

    default public CompletionStage<Void> commit(Transaction transaction) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.TRANSACTIONAL + ", but it does not implement commit");
    }

    default public CompletionStage<Void> rollback(Transaction transaction) {
        throw new UnsupportedOperationException("Store characteristic included " + Characteristic.TRANSACTIONAL + ", but it does not implement rollback");
    }

    @Experimental
    default public boolean ignoreCommandWithFlags(long commandFlags) {
        return false;
    }

    public static enum Characteristic {
        SHAREABLE,
        READ_ONLY,
        WRITE_ONLY,
        BULK_READ,
        TRANSACTIONAL,
        SEGMENTABLE,
        EXPIRATION;

    }

    public static interface SegmentedPublisher<Type>
    extends Publisher<Type> {
        public int getSegment();
    }
}

