/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.LiveStatistics;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosClock;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.PerfCommand;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerBenchmarkBuilder;

@Command(name="producer", description="It will send messages to a broker instance")
public class PerfProducerCommand
extends PerfCommand {
    @Option(name={"--persistent"}, description="It will send messages persistently. Default is non persistent")
    protected boolean persistent = false;
    @Option(name={"--message-size"}, description="Size of each byteMessage (Default is 1024)")
    protected int messageSize = 1024;
    @Option(name={"--rate"}, description="Expected total message rate. (Default is unbounded)")
    protected Long rate = null;
    @Option(name={"--ttl"}, description="TTL for each message")
    protected long ttl = 0L;
    @Option(name={"--group"}, description="Message Group to be used")
    protected String msgGroupID = null;
    @Option(name={"--shared-connections"}, description="It create --threads shared connections among producers (Default: not shared)")
    protected boolean sharedConnections = false;
    @Option(name={"--tx-size"}, description="TX Size")
    protected long txSize;
    @Option(name={"--producers"}, description="Number of producers to use for each generated destination (Default: 1)")
    protected int producersPerDestination = 1;
    @Option(name={"--threads"}, description="Number of worker threads to schedule producer load tasks (Default: 1)")
    protected int threads = 1;
    @Option(name={"--max-pending"}, description="How many not yet completed messages can exists  (Default is 1)")
    protected long maxPending = 1L;
    @Option(name={"--enable-msg-id"}, description="Enable setting JMS messageID per-message (Default: disabled)")
    protected boolean enableMessageID;
    @Option(name={"--enable-timestamp"}, description="Enable setting JMS timestamp per-message (Default: disabled)")
    protected boolean enableTimestamp;
    protected volatile BenchmarkService benchmark;

    @Override
    protected void onExecuteBenchmark(ConnectionFactory factory, Destination[] jmsDestinations, ActionContext context) throws Exception {
        LiveStatistics statistics;
        if (this.getClientID() != null) {
            context.err.println("ClientID configuration is not supported");
        }
        MicrosTimeProvider timeProvider = () -> TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        if (MicrosClock.isAvailable()) {
            timeProvider = MicrosClock::now;
        } else {
            context.err.println("Microseconds wall-clock time not available: using System::currentTimeMillis. Add --add-opens=java.base/jdk.internal.misc=ALL-UNNAMED to the JVM parameters to enable it.");
        }
        int totalProducers = this.producersPerDestination * jmsDestinations.length;
        if (this.threads >= totalProducers && this.threads > totalProducers) {
            context.err.println("Doesn't make sense to set workers > producers: auto-adjusting it to be the same as the producer count");
            this.threads = totalProducers;
        }
        DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(this.threads){

            protected EventLoop newChild(Executor executor, Object ... args) {
                return new DefaultEventLoop((EventLoopGroup)this, executor){

                    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                        return new LinkedTransferQueue<Runnable>();
                    }
                };
            }
        };
        boolean warmingUp = this.warmup != 0;
        StringBuilder skratchBuffer = new StringBuilder();
        try (ProducerBenchmark benchmark = new ProducerBenchmarkBuilder().setPersistent(this.persistent).setDestinations(jmsDestinations).setFactory(factory).setTtl(this.ttl).setTransactionCapacity(this.txSize).setGroup(this.msgGroupID).setProducers(this.producersPerDestination).setMessageRate(this.rate).setMessageCount(this.messageCount).setMessageSize(this.messageSize).setTimeProvider(timeProvider).setLoopGroup((EventLoopGroup)eventLoopGroup).setMaxPending(this.maxPending).setSharedConnections(this.sharedConnections).setEnableMessageID(this.enableMessageID).setEnableTimestamp(this.enableTimestamp).createProducerBenchmark();){
            this.benchmark = benchmark;
            benchmark.start();
            long now = System.currentTimeMillis();
            long endWarmup = this.warmup > 0 ? now + TimeUnit.SECONDS.toMillis(this.warmup) : 0L;
            long end = this.duration > 0 ? now + TimeUnit.SECONDS.toMillis(this.duration) : 0L;
            statistics = new LiveStatistics(this.reportFileName, this.hdrFileName, benchmark.getGenerators(), null);
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
            warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, end, benchmark);
        }
        statistics.sampleMetrics(warmingUp);
        skratchBuffer.setLength(0);
        statistics.outSummary(skratchBuffer);
        if (!this.isSilentInput()) {
            context.out.println(skratchBuffer);
        }
        eventLoopGroup.shutdownGracefully();
        statistics.close();
    }

    @Override
    protected void onInterruptBenchmark() {
        BenchmarkService benchmark = this.benchmark;
        if (benchmark != null) {
            benchmark.close();
        }
    }
}

