/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.integration;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.impl.LegacyJMSConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.dto.ServerDTO;
import org.apache.activemq.artemis.integration.Broker;
import org.apache.activemq.artemis.integration.bootstrap.ActiveMQBootstrapLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class FileBroker
implements Broker {
    private final String configurationUrl;
    private final ActivateCallback activateCallback;
    private boolean started;
    private final ActiveMQSecurityManager securityManager;
    private Map<String, ActiveMQComponent> components;

    public FileBroker(ServerDTO broker, ActiveMQSecurityManager security, ActivateCallback activateCallback) {
        this.securityManager = security;
        this.configurationUrl = broker.configuration;
        this.activateCallback = activateCallback;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.components == null) {
            this.createComponents();
        }
        ArrayList<ActiveMQComponent> componentsByStartOrder = this.getComponentsByStartOrder(this.components);
        ActiveMQBootstrapLogger.LOGGER.serverStarting();
        for (ActiveMQComponent component : componentsByStartOrder) {
            component.start();
        }
        this.started = true;
    }

    private void createDirectories(FileConfiguration fileConfiguration) {
        fileConfiguration.getPagingLocation().mkdirs();
        fileConfiguration.getJournalLocation().mkdirs();
        fileConfiguration.getBindingsLocation().mkdirs();
        fileConfiguration.getLargeMessagesLocation().mkdirs();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean isShutdown) throws Exception {
        if (!this.started) {
            return;
        }
        ActiveMQComponent[] mqComponents = new ActiveMQComponent[this.components.size()];
        this.components.values().toArray(mqComponents);
        for (int i = mqComponents.length - 1; i >= 0; --i) {
            if (mqComponents[i] instanceof ServiceComponent) {
                ((ServiceComponent)mqComponents[i]).stop(isShutdown);
                continue;
            }
            mqComponents[i].stop();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map<String, ActiveMQComponent> getComponents() {
        return this.components;
    }

    @Override
    public void createComponents() throws Exception {
        FileConfiguration configuration = new FileConfiguration();
        LegacyJMSConfiguration legacyJMSConfiguration = new LegacyJMSConfiguration((Configuration)configuration);
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(this.configurationUrl);
        fileDeploymentManager.addDeployable((Deployable)configuration).addDeployable((Deployable)legacyJMSConfiguration);
        fileDeploymentManager.readConfiguration();
        this.createDirectories(configuration);
        this.components = fileDeploymentManager.buildService(this.securityManager, ManagementFactory.getPlatformMBeanServer(), this.activateCallback);
    }

    private ArrayList<ActiveMQComponent> getComponentsByStartOrder(Map<String, ActiveMQComponent> components) {
        ArrayList<ActiveMQComponent> activeMQComponents = new ArrayList<ActiveMQComponent>();
        ActiveMQComponent jmsComponent = components.get("jms");
        if (jmsComponent != null) {
            activeMQComponents.add(jmsComponent);
        }
        activeMQComponents.add(components.get("core"));
        return activeMQComponents;
    }

    @Override
    public ActiveMQServer getServer() {
        return (ActiveMQServer)this.components.get("core");
    }
}

