/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.management.ManagementInterfaceAddStepHandler;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerOperationHandlerFactory;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NativeRemotingManagementAddHandler
extends ManagementInterfaceAddStepHandler {
    public static final NativeRemotingManagementAddHandler INSTANCE = new NativeRemotingManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY;
    }

    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName endpointName = RemotingServices.SUBSYSTEM_ENDPOINT;
        ManagementChannelRegistryService.addService((ServiceTarget)serviceTarget, (ServiceName)endpointName);
        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)endpointName, (ModelControllerOperationHandlerFactory)new ModelControllerOperationHandlerFactory(){

            public AbstractModelControllerOperationHandlerFactoryService newInstance(Consumer<AbstractModelControllerOperationHandlerFactoryService> serviceConsumer, Supplier<ModelController> modelControllerSupplier, Supplier<ExecutorService> executorSupplier, Supplier<ScheduledExecutorService> scheduledExecutorSupplier) {
                return new ModelControllerClientOperationHandlerFactoryService(serviceConsumer, modelControllerSupplier, executorSupplier, scheduledExecutorSupplier);
            }
        }, (ServiceName)Services.JBOSS_SERVER_CONTROLLER, (String)"management", (ServiceName)ServerService.EXECUTOR_CAPABILITY.getCapabilityServiceName(), (ServiceName)ServerService.JBOSS_SERVER_SCHEDULED_EXECUTOR);
        List<ServiceName> requiredServices = Collections.singletonList(RemotingServices.channelServiceName((ServiceName)endpointName, (String)"management"));
        this.addVerifyInstallationStep(context, requiredServices);
    }
}

