/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.suspend;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.as.controller.notification.NotificationHandlerRegistry;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.CountingRequestCountCallback;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SuspendController
implements Service<SuspendController> {
    private Timer timer;
    private State state = State.SUSPENDED;
    private final List<ServerActivity> activities = new ArrayList<ServerActivity>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private final InjectedValue<NotificationHandlerRegistry> notificationHandlerRegistry = new InjectedValue();
    private int outstandingCount;
    private boolean startSuspended = false;
    private final ServerActivityCallback listener = this::activityPaused;

    public void setStartSuspended(boolean startSuspended) {
        this.startSuspended = startSuspended;
        this.state = State.SUSPENDED;
    }

    public synchronized void suspend(long timeoutMillis) {
        if (this.state == State.SUSPENDED) {
            return;
        }
        if (timeoutMillis > 0L) {
            ServerLogger.ROOT_LOGGER.suspendingServer(timeoutMillis);
        } else if (timeoutMillis < 0L) {
            ServerLogger.ROOT_LOGGER.suspendingServerWithNoTimeout();
        } else {
            ServerLogger.ROOT_LOGGER.suspendingServer();
        }
        this.state = State.PRE_SUSPEND;
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.suspendStarted();
        }
        this.outstandingCount = this.activities.size();
        if (this.outstandingCount == 0) {
            this.handlePause();
        } else {
            CountingRequestCountCallback cb = new CountingRequestCountCallback(this.outstandingCount, () -> {
                this.state = State.SUSPENDING;
                for (ServerActivity activity : this.activities) {
                    activity.suspended(this.listener);
                }
            });
            for (ServerActivity activity : this.activities) {
                activity.preSuspend(cb);
            }
            if (timeoutMillis > 0L) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SuspendController.this.timeout();
                    }
                }, timeoutMillis);
            } else if (timeoutMillis == 0L) {
                this.timeout();
            }
        }
    }

    public void nonGracefulStart() {
        this.resume(false);
    }

    public void resume() {
        this.resume(true);
    }

    private synchronized void resume(boolean gracefulStart) {
        if (this.state == State.RUNNING) {
            return;
        }
        if (!gracefulStart) {
            ServerLogger.ROOT_LOGGER.startingNonGraceful();
        } else {
            ServerLogger.ROOT_LOGGER.resumingServer();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.cancelled();
        }
        for (ServerActivity activity : this.activities) {
            try {
                activity.resume();
            }
            catch (Exception e) {
                ServerLogger.ROOT_LOGGER.failedToResume(activity, e);
            }
        }
        this.state = State.RUNNING;
    }

    public synchronized void registerActivity(ServerActivity activity) {
        this.activities.add(activity);
        if (this.state != State.RUNNING) {
            activity.suspended(() -> {});
        }
    }

    public synchronized void unRegisterActivity(ServerActivity activity) {
        this.activities.remove(activity);
    }

    public synchronized void start(StartContext startContext) throws StartException {
        if (this.startSuspended) {
            ServerLogger.AS_ROOT_LOGGER.startingServerSuspended();
        }
    }

    public synchronized void stop(StopContext stopContext) {
    }

    public State getState() {
        return this.state;
    }

    private synchronized void activityPaused() {
        --this.outstandingCount;
        this.handlePause();
    }

    private void handlePause() {
        if (this.outstandingCount == 0) {
            this.state = State.SUSPENDED;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
                listener.complete();
            }
        }
    }

    private synchronized void timeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.timeout();
        }
    }

    public synchronized void addListener(OperationListener listener) {
        this.operationListeners.add(listener);
    }

    public synchronized void removeListener(OperationListener listener) {
        this.operationListeners.remove(listener);
    }

    public SuspendController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<NotificationHandlerRegistry> getNotificationHandlerRegistry() {
        return this.notificationHandlerRegistry;
    }

    public static enum State {
        RUNNING,
        PRE_SUSPEND,
        SUSPENDING,
        SUSPENDED;

    }
}

