/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.nio.file.Path;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.installationmanager.HistoryResult;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrHistoryHandler
extends InstMgrOperationStepHandler {
    public static final String OPERATION_NAME = "history";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("history", InstMgrResolver.RESOLVER).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setReplyType(ModelType.LIST).setRuntimeOnly().setReplyValueType(ModelType.OBJECT).build();

    InstMgrHistoryHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                try {
                    Path serverHome = InstMgrHistoryHandler.this.imService.getHomeDir();
                    MavenOptions mavenOptions = new MavenOptions(null, false);
                    InstallationManager installationManager = InstMgrHistoryHandler.this.imf.create(serverHome, mavenOptions);
                    ModelNode resulList = new ModelNode();
                    List history = installationManager.history();
                    for (HistoryResult hr : history) {
                        ModelNode entry = new ModelNode();
                        entry.get("hash").set(hr.getName());
                        entry.get("timestamp").set(hr.timestamp().toString());
                        entry.get("type").set(hr.getType().toLowerCase());
                        if (hr.getDescription() != null) {
                            entry.get("description").set(hr.getDescription());
                        }
                        resulList.add(entry);
                    }
                    context.getResult().set(resulList);
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

