/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagementConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagementProvider;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.extension.clustering.ejb.InfinispanTimerManagementResourceDefinition;
import org.wildfly.extension.clustering.ejb.TimerContextMarshallerFactory;

public class InfinispanTimerManagementServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
InfinispanTimerManagementConfiguration {
    private volatile String containerName;
    private volatile String cacheName;
    private volatile Integer maxActiveTimers;
    private volatile Function<Module, ByteBufferMarshaller> marshallerFactory;

    public InfinispanTimerManagementServiceConfigurator(PathAddress address) {
        super((Capability)InfinispanTimerManagementResourceDefinition.Capability.TIMER_MANAGEMENT_PROVIDER, address);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanTimerManagementResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanTimerManagementResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.maxActiveTimers = InfinispanTimerManagementResourceDefinition.Attribute.MAX_ACTIVE_TIMERS.resolveModelAttribute((ExpressionResolver)context, model).asIntOrNull();
        this.marshallerFactory = TimerContextMarshallerFactory.valueOf(InfinispanTimerManagementResourceDefinition.Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer provider = builder.provides(new ServiceName[]{name});
        return builder.setInstance(Service.newInstance((Consumer)provider, (Object)new InfinispanTimerManagementProvider((InfinispanTimerManagementConfiguration)this))).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Function<Module, ByteBufferMarshaller> getMarshallerFactory() {
        return this.marshallerFactory;
    }

    public Integer getMaxActiveTimers() {
        return this.maxActiveTimers;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

