/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.info;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.contact.ContactReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.license.LicenseReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class InfoReader {
    private InfoReader() {
    }

    public static Info readInfo(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotation("@Info");
        AnnotationInstance nested = annotationValue.asNested();
        InfoImpl info = new InfoImpl();
        info.setTitle((String)Annotations.value(nested, "title"));
        info.setDescription((String)Annotations.value(nested, "description"));
        info.setTermsOfService((String)Annotations.value(nested, "termsOfService"));
        info.setContact(ContactReader.readContact(context, nested.value("contact")));
        info.setLicense(LicenseReader.readLicense(context, nested.value("license")));
        info.setVersion((String)Annotations.value(nested, "version"));
        info.setExtensions(ExtensionReader.readExtensions(context, nested));
        return info;
    }

    public static Info readInfo(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.logger.singleJsonNode("Info");
        InfoImpl info = new InfoImpl();
        info.setTitle(JsonUtil.stringProperty(node, "title"));
        info.setDescription(JsonUtil.stringProperty(node, "description"));
        info.setTermsOfService(JsonUtil.stringProperty(node, "termsOfService"));
        info.setContact(ContactReader.readContact(node.get("contact")));
        info.setLicense(LicenseReader.readLicense(node.get("license")));
        info.setVersion(JsonUtil.stringProperty(node, "version"));
        ExtensionReader.readExtensions(node, info);
        return info;
    }
}

